/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.async.function.AsyncSupplier;
import io.activej.bytebuf.ByteBuf;
import io.activej.http.AsyncServlet;
import io.activej.http.ContentType;
import io.activej.http.HttpError;
import io.activej.http.HttpHeaderValue;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.MediaType;
import io.activej.http.MediaTypes;
import io.activej.http.loader.ResourceIsADirectoryException;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.http.loader.StaticLoader;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StaticServlet
implements AsyncServlet {
    public static final Charset DEFAULT_TXT_ENCODING = StandardCharsets.UTF_8;
    private final StaticLoader resourceLoader;
    private Function<String, ContentType> contentTypeResolver = StaticServlet::getContentType;
    private Function<HttpRequest, @Nullable String> pathMapper = HttpRequest::getRelativePath;
    private Supplier<HttpResponse> responseSupplier = HttpResponse::ok200;
    private final Set<String> indexResources = new LinkedHashSet<String>();
    @Nullable
    private String defaultResource;

    private StaticServlet(StaticLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public static StaticServlet create(StaticLoader resourceLoader) {
        return new StaticServlet(resourceLoader);
    }

    public static StaticServlet create(StaticLoader resourceLoader, String page) {
        return StaticServlet.create(resourceLoader).withMappingTo(page);
    }

    public static StaticServlet ofClassPath(Executor executor, String path) {
        return new StaticServlet(StaticLoader.ofClassPath(executor, path));
    }

    public static StaticServlet ofPath(Executor executor, Path path) {
        return new StaticServlet(StaticLoader.ofPath(executor, path));
    }

    public StaticServlet withContentType(ContentType contentType) {
        return this.withContentTypeResolver($ -> contentType);
    }

    public StaticServlet withContentTypeResolver(Function<String, ContentType> contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
        return this;
    }

    public StaticServlet withMapping(Function<HttpRequest, String> fn) {
        this.pathMapper = fn;
        return this;
    }

    public StaticServlet withMappingTo(String path) {
        if (this.contentTypeResolver == StaticServlet::getContentType) {
            this.withContentType(StaticServlet.getContentType(path));
        }
        return this.withMapping($ -> path);
    }

    public StaticServlet withMappingNotFoundTo(String defaultResource) {
        this.defaultResource = defaultResource;
        return this;
    }

    public StaticServlet withIndexResources(String ... indexResources) {
        this.indexResources.addAll(Arrays.asList(indexResources));
        return this;
    }

    public StaticServlet withIndexHtml() {
        this.indexResources.add("index.html");
        return this;
    }

    public StaticServlet withResponse(Supplier<HttpResponse> responseSupplier) {
        this.responseSupplier = responseSupplier;
        return this;
    }

    public static ContentType getContentType(String path) {
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return ContentType.of(MediaTypes.OCTET_STREAM);
        }
        String ext = path.substring(pos + 1);
        MediaType mime = MediaTypes.getByExtension(ext);
        if (mime == null) {
            mime = MediaTypes.OCTET_STREAM;
        }
        ContentType type = mime.isTextType() ? ContentType.of(mime, DEFAULT_TXT_ENCODING) : ContentType.of(mime);
        return type;
    }

    private HttpResponse createHttpResponse(ByteBuf buf, ContentType contentType) {
        return this.responseSupplier.get().withBody(buf).withHeader(HttpHeaders.CONTENT_TYPE, HttpHeaderValue.ofContentType(contentType));
    }

    @NotNull
    public final Promise<HttpResponse> serve(@NotNull HttpRequest request) {
        String mappedPath = this.pathMapper.apply(request);
        if (mappedPath == null) {
            return Promise.ofException((Throwable)HttpError.notFound404());
        }
        ContentType contentType = this.contentTypeResolver.apply(mappedPath);
        return Promise.complete().then(() -> mappedPath.endsWith("/") || mappedPath.isEmpty() ? this.tryLoadIndexResource(mappedPath) : this.resourceLoader.load(mappedPath).map(byteBuf -> this.createHttpResponse((ByteBuf)byteBuf, contentType)).thenEx((value, e) -> {
            if (e instanceof ResourceIsADirectoryException) {
                return this.tryLoadIndexResource(mappedPath);
            }
            return Promise.of((Object)value, (Throwable)e);
        })).thenEx((response, e) -> {
            if (e == null) {
                return Promise.of((Object)response);
            }
            if (e instanceof ResourceNotFoundException) {
                return this.tryLoadDefaultResource();
            }
            return Promise.ofException((Throwable)HttpError.ofCode(400, e));
        });
    }

    @NotNull
    private Promise<HttpResponse> tryLoadIndexResource(String mappedPath) {
        String dirPath = mappedPath.endsWith("/") || mappedPath.isEmpty() ? mappedPath : mappedPath + '/';
        return Promises.first(this.indexResources.stream().map(indexResource -> AsyncSupplier.of(() -> this.resourceLoader.load(dirPath + indexResource).map(byteBuf -> this.createHttpResponse((ByteBuf)byteBuf, this.contentTypeResolver.apply((String)indexResource)))))).thenEx((response, e) -> e == null ? Promise.of((Object)response) : Promise.ofException((Throwable)new ResourceNotFoundException("Could not find '" + mappedPath + '\'', (Throwable)e)));
    }

    @NotNull
    private Promise<? extends HttpResponse> tryLoadDefaultResource() {
        return this.defaultResource != null ? this.resourceLoader.load(this.defaultResource).map(buf -> this.createHttpResponse((ByteBuf)buf, this.contentTypeResolver.apply(this.defaultResource))) : Promise.ofException((Throwable)HttpError.notFound404());
    }
}

