/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.ApplicationSettings;
import io.activej.http.MalformedHttpException;
import io.activej.http.Protocol;
import io.activej.http.QueryParameter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlParser {
    public static final byte COLON = 58;
    public static final byte HASH = 35;
    public static final byte SLASH = 47;
    public static final byte QUESTION_MARK = 63;
    private static final ThreadLocal<byte[]> CACHED_BUFFERS = new ThreadLocal();
    private static final Charset CHARSET = ApplicationSettings.getCharset(UrlParser.class, (String)"charset", (Charset)StandardCharsets.ISO_8859_1);
    private static final byte IPV6_OPENING_BRACKET = 91;
    private static final byte[] IPV6_CLOSING_SECTION_WITH_PORT = ByteBufStrings.encodeAscii((String)"]:");
    private static final byte[] PROTOCOL_DELIMITER = ByteBufStrings.encodeAscii((String)"://");
    private final byte[] raw;
    private final short limit;
    private final short offset;
    private int portValue = -1;
    private Protocol protocol;
    private short host = (short)-1;
    private short path = (short)-1;
    private short port = (short)-1;
    private short pathEnd = (short)-1;
    private short query = (short)-1;
    private short fragment = (short)-1;
    short pos = (short)-1;
    int[] queryPositions;
    private static final int[] NO_PARAMETERS = new int[0];

    private UrlParser(byte[] raw, short offset, short limit) {
        this.raw = raw;
        this.offset = offset;
        this.limit = limit;
    }

    @NotNull
    public static UrlParser of(@NotNull String url) {
        return UrlParser.of(url.getBytes(StandardCharsets.ISO_8859_1), 0, url.length());
    }

    @NotNull
    public static UrlParser of(@NotNull byte[] url, int offset, int limit) {
        try {
            UrlParser httpUrl = UrlParser.createParser(url, offset, limit);
            httpUrl.parse(false);
            return httpUrl;
        }
        catch (MalformedHttpException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public static UrlParser parse(@NotNull String url) throws MalformedHttpException {
        return UrlParser.parse(url.getBytes(StandardCharsets.ISO_8859_1), 0, url.length());
    }

    @NotNull
    public static UrlParser parse(byte[] url, int offset, int limit) throws MalformedHttpException {
        UrlParser httpUrl = UrlParser.createParser(url, offset, limit);
        httpUrl.parse(true);
        return httpUrl;
    }

    private static UrlParser createParser(byte[] url, int offset, int limit) throws MalformedHttpException {
        if (limit <= Short.MAX_VALUE) {
            return new UrlParser(url, (short)offset, (short)limit);
        }
        int urlLength = limit - offset;
        if (urlLength > Short.MAX_VALUE) {
            throw new MalformedHttpException("URL length exceeds 32767 bytes");
        }
        byte[] urlBytes = new byte[urlLength];
        System.arraycopy(url, offset, urlBytes, 0, urlLength);
        return new UrlParser(urlBytes, 0, (short)urlLength);
    }

    private void parse(boolean isRelativePathAllowed) throws MalformedHttpException {
        int index = this.indexOf(PROTOCOL_DELIMITER, (int)this.offset);
        int protocolLength = index - this.offset;
        if (protocolLength < 0 || protocolLength > 5) {
            if (!isRelativePathAllowed) {
                throw new MalformedHttpException("Partial URI is not allowed: " + this);
            }
            index = this.offset;
        } else {
            int colon;
            int closingSection;
            if (protocolLength == 5 && this.startsWith(Protocol.HTTPS.lowercaseBytes(), this.offset)) {
                this.protocol = Protocol.HTTPS;
            } else if (protocolLength == 4 && this.startsWith(Protocol.HTTP.lowercaseBytes(), this.offset)) {
                this.protocol = Protocol.HTTP;
            } else if (protocolLength == 3 && this.startsWith(Protocol.WSS.lowercaseBytes(), this.offset)) {
                this.protocol = Protocol.WSS;
            } else if (protocolLength == 2 && this.startsWith(Protocol.WS.lowercaseBytes(), this.offset)) {
                this.protocol = Protocol.WS;
            } else {
                throw new MalformedHttpException("Unsupported schema: " + new String(this.raw, (int)this.offset, protocolLength, CHARSET));
            }
            this.host = (short)(index += PROTOCOL_DELIMITER.length);
            int hostPortEnd = this.findHostPortEnd(this.host);
            if (this.host == hostPortEnd || this.indexOf((byte)58, (int)this.host) == this.host) {
                throw new MalformedHttpException("Domain name cannot be null or empty");
            }
            this.port = this.indexOf((byte)91, index) != -1 ? (short)((closingSection = this.indexOf(IPV6_CLOSING_SECTION_WITH_PORT, index)) != -1 ? closingSection + 2 : closingSection) : (short)((colon = this.indexOf((byte)58, index)) != -1 && colon < hostPortEnd ? (int)(colon + 1) : -1);
            if (this.port != -1) {
                this.portValue = this.parsePort(hostPortEnd);
            } else if (this.host != -1) {
                this.portValue = this.protocol.isSecure() ? 443 : 80;
            }
            index = hostPortEnd;
        }
        if (index == this.limit) {
            return;
        }
        if (this.raw[index] == 47) {
            this.pos = this.path = (short)index;
            this.pathEnd = (short)this.findPathEnd(this.path);
            index = this.pathEnd;
        }
        if (index == this.limit) {
            return;
        }
        if (this.raw[index] == 63) {
            this.query = (short)(index + 1);
            index = this.findQueryEnd(this.query);
        }
        if (index == this.limit) {
            return;
        }
        if (this.raw[index] == 35) {
            this.fragment = (short)(index + 1);
        }
    }

    private int findHostPortEnd(int from) {
        for (int i = from; i < this.limit; ++i) {
            byte b = this.raw[i];
            if (b != 47 && b != 63 && b != 35) continue;
            return i;
        }
        return this.limit;
    }

    private int findPathEnd(int from) {
        for (int i = from; i < this.limit; ++i) {
            byte b = this.raw[i];
            if (b != 63 && b != 35) continue;
            return i;
        }
        return this.limit;
    }

    private int findQueryEnd(int from) {
        int queryEnd = this.indexOf((byte)35, from);
        return queryEnd != -1 ? queryEnd : (int)this.limit;
    }

    public boolean isRelativePath() {
        return this.host == -1;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Nullable
    public String getHostAndPort() {
        if (this.host == -1) {
            return null;
        }
        int end = this.path != -1 ? this.path : (this.query != -1 ? this.query - 1 : (this.fragment != -1 ? this.fragment - 1 : (int)this.limit));
        return new String(this.raw, (int)this.host, end - this.host, CHARSET);
    }

    @Nullable
    public String getHost() {
        if (this.host == -1) {
            return null;
        }
        int end = this.port != -1 ? this.port - 1 : (this.path != -1 ? (int)this.path : (this.query != -1 ? this.query - 1 : (int)this.limit));
        return new String(this.raw, (int)this.host, end - this.host, CHARSET);
    }

    public int getPort() {
        return this.portValue;
    }

    @NotNull
    public String getPathAndQuery() {
        if (this.path == -1) {
            if (this.query == -1) {
                return "/";
            }
            int queryEnd = this.fragment == -1 ? this.limit : this.fragment - 1;
            return new String(this.raw, (int)this.query, queryEnd - this.query, CHARSET);
        }
        int queryEnd = this.fragment == -1 ? this.limit : this.fragment - 1;
        return new String(this.raw, (int)this.path, queryEnd - this.path, CHARSET);
    }

    @NotNull
    public String getPath() {
        if (this.path == -1) {
            return "/";
        }
        return new String(this.raw, (int)this.path, this.pathEnd - this.path, CHARSET);
    }

    @NotNull
    public String getQuery() {
        if (this.query == -1) {
            return "";
        }
        int queryEnd = this.fragment == -1 ? this.limit : this.fragment - 1;
        return new String(this.raw, (int)this.query, queryEnd - this.query, CHARSET);
    }

    @NotNull
    public String getFragment() {
        if (this.fragment == -1) {
            return "";
        }
        return new String(this.raw, (int)this.fragment, this.limit - this.fragment, CHARSET);
    }

    int getPathAndQueryLength() {
        int len = 0;
        len += this.path == -1 ? 1 : this.pathEnd - this.path;
        return len += this.query == -1 ? 0 : (this.fragment == -1 ? this.limit : this.fragment - 1) - this.query + 1;
    }

    void writePathAndQuery(@NotNull ByteBuf buf) {
        if (this.path == -1) {
            buf.put((byte)47);
        } else {
            for (int i = this.path; i < this.pathEnd; ++i) {
                buf.put(this.raw[i]);
            }
        }
        if (this.query != -1) {
            buf.put((byte)63);
            int queryEnd = this.fragment == -1 ? this.limit : this.fragment - 1;
            for (int i = this.query; i < queryEnd; ++i) {
                buf.put(this.raw[i]);
            }
        }
    }

    @Nullable
    public String getQueryParameter(@NotNull String key) {
        if (this.query == -1) {
            return null;
        }
        if (this.queryPositions == null) {
            this.parseQueryParameters();
        }
        return this.findParameter(key);
    }

    @NotNull
    public List<String> getQueryParameters(@NotNull String key) {
        if (this.query == -1) {
            return Collections.emptyList();
        }
        if (this.queryPositions == null) {
            this.parseQueryParameters();
        }
        return this.findParameters(key);
    }

    @NotNull
    public Iterable<QueryParameter> getQueryParametersIterable() {
        if (this.query == -1) {
            return Collections.emptyList();
        }
        if (this.queryPositions == null) {
            this.parseQueryParameters();
        }
        return () -> new QueryParamIterator();
    }

    @NotNull
    public Map<String, String> getQueryParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (QueryParameter queryParameter : this.getQueryParametersIterable()) {
            map.put(queryParameter.getKey(), queryParameter.getValue());
        }
        return map;
    }

    void parseQueryParameters() {
        int queryEnd = this.fragment == -1 ? this.limit : this.fragment - 1;
        this.queryPositions = this.parseQueryParameters(queryEnd);
    }

    @NotNull
    int[] parseQueryParameters(int end) {
        if (this.query == end) {
            return NO_PARAMETERS;
        }
        assert (this.limit >= end);
        assert (this.query != -1);
        int[] positions = new int[8];
        int k = 0;
        int keyStart = this.query;
        while (keyStart < end) {
            byte b;
            int keyEnd;
            for (keyEnd = keyStart; keyEnd < end && (b = this.raw[keyEnd]) != 38 && b != 61; ++keyEnd) {
            }
            if (keyStart != keyEnd) {
                if (k >= positions.length) {
                    positions = Arrays.copyOf(positions, positions.length * 2);
                }
                positions[k++] = keyStart | keyEnd << 16;
            }
            while (keyStart < end && this.raw[keyStart++] != 38) {
            }
        }
        return positions;
    }

    @NotNull
    public static Map<String, String> parseQueryIntoMap(@NotNull String query) {
        return UrlParser.parseQueryIntoMap(query.getBytes(StandardCharsets.ISO_8859_1), 0, query.length());
    }

    @NotNull
    static Map<String, String> parseQueryIntoMap(byte[] query, int offset, int limit) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int keyStart = offset;
        while (keyStart < limit) {
            byte b;
            int keyEnd;
            for (keyEnd = keyStart; keyEnd < limit && (b = query[keyEnd]) != 38 && b != 61; ++keyEnd) {
            }
            if (keyStart != keyEnd) {
                result.putIfAbsent(new String(query, keyStart, keyEnd - keyStart, CHARSET), UrlParser.keyValueDecode(query, keyEnd, limit));
            }
            while (keyStart < limit && query[keyStart++] != 38) {
            }
        }
        return result;
    }

    @Nullable
    String findParameter(@NotNull String key) {
        for (int record : this.queryPositions) {
            if (record == 0) break;
            int keyStart = record & 0xFFFF;
            int keyEnd = record >>> 16;
            if (!this.isEqual(key, keyStart, keyEnd)) continue;
            return UrlParser.keyValueDecode(this.raw, keyEnd, this.limit);
        }
        return null;
    }

    @NotNull
    List<String> findParameters(@NotNull String key) {
        ArrayList<String> container = new ArrayList<String>();
        for (int record : this.queryPositions) {
            if (record == 0) break;
            int keyStart = record & 0xFFFF;
            int keyEnd = record >>> 16;
            if (!this.isEqual(key, keyStart, keyEnd)) continue;
            container.add(UrlParser.keyValueDecode(this.raw, keyEnd, this.limit));
        }
        return container;
    }

    @NotNull
    String getPartialPath() {
        if (this.pos == -1 || this.pos > this.pathEnd) {
            return "/";
        }
        return new String(this.raw, (int)this.pos, this.pathEnd - this.pos, CHARSET);
    }

    String pollUrlPart() {
        if (this.pos < this.pathEnd) {
            String part;
            int start = this.pos + 1;
            int nextSlash = this.indexOf((byte)47, start);
            short s = this.pos = nextSlash > this.pathEnd ? this.pathEnd : (short)nextSlash;
            if (this.pos == -1) {
                part = new String(this.raw, start, this.pathEnd - start, CHARSET);
                this.pos = this.limit;
            } else {
                part = new String(this.raw, start, this.pos - start, CHARSET);
            }
            return part;
        }
        return "";
    }

    private boolean isEqual(@NotNull String key, int start, int end) {
        if (end - start != key.length()) {
            return false;
        }
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == this.raw[start + i]) continue;
            return false;
        }
        return true;
    }

    private int parsePort(int end) throws MalformedHttpException {
        if (this.port == end) {
            throw new MalformedHttpException("Empty port value");
        }
        if (end - this.port > 5) {
            throw new MalformedHttpException("Bad port: " + new String(this.raw, (int)this.port, end - this.port, CHARSET));
        }
        int result = 0;
        for (int i = this.port; i < end; ++i) {
            int c = this.raw[i] - 48;
            if (c < 0 || c > 9) {
                throw new MalformedHttpException("Bad port: " + new String(this.raw, (int)this.port, end - this.port, CHARSET));
            }
            result = c + result * 10;
        }
        if (result > 65535) {
            throw new MalformedHttpException("Bad port: " + new String(this.raw, (int)this.port, end - this.port, CHARSET));
        }
        return result;
    }

    @Nullable
    private static String keyValueDecode(byte[] url, int keyEnd, int limit) {
        return UrlParser.urlParse(url, keyEnd < limit && url[keyEnd] == 61 ? keyEnd + 1 : keyEnd, limit);
    }

    @Nullable
    public static String urlParse(@NotNull String s) {
        return UrlParser.urlParse(ByteBufStrings.encodeAscii((String)s), 0, s.length());
    }

    @Nullable
    private static String urlParse(byte[] url, int pos, int limit) {
        for (int i = pos; i < limit; ++i) {
            byte c = url[i];
            if (c == 43 || c == 37) {
                return UrlParser.urlParse(url, pos, limit, i);
            }
            if (c != 38 && c != 35) continue;
            return new String(url, pos, i - pos, CHARSET);
        }
        return new String(url, pos, limit - pos, CHARSET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String urlParse(byte[] url, int pos, int limit, int encodedSuffixPos) {
        byte[] bytes = CACHED_BUFFERS.get();
        if (bytes == null || bytes.length < limit - pos) {
            int newCount = limit - pos + (limit - pos << 1);
            bytes = new byte[newCount];
            CACHED_BUFFERS.set(bytes);
        }
        int bytesPos = 0;
        while (pos < encodedSuffixPos) {
            bytes[bytesPos++] = url[pos];
            ++pos;
        }
        try {
            block8: while (pos < limit) {
                byte b = url[pos];
                switch (b) {
                    case 35: 
                    case 38: {
                        return new String(bytes, 0, bytesPos, StandardCharsets.UTF_8);
                    }
                    case 43: {
                        bytes[bytesPos++] = 32;
                        ++pos;
                        continue block8;
                    }
                    case 37: {
                        while (pos + 2 < limit && b == 37) {
                            bytes[bytesPos++] = (byte)((UrlParser.decodeHex(url[pos + 1]) << 4) + UrlParser.decodeHex(url[pos + 2]));
                            if ((pos += 3) >= limit) continue;
                            b = url[pos];
                        }
                        if (pos >= limit || b != 37) continue block8;
                        return null;
                    }
                }
                bytes[bytesPos++] = b;
                ++pos;
            }
            return new String(bytes, 0, bytesPos, StandardCharsets.UTF_8);
        }
        catch (MalformedHttpException e) {
            return null;
        }
    }

    private static byte decodeHex(byte b) throws MalformedHttpException {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        throw new MalformedHttpException("Failed to decode hex digit from '" + b + '\'');
    }

    private boolean startsWith(byte[] subArray, int from) {
        for (int j = 0; j < subArray.length; ++j) {
            if (subArray[j] == this.raw[from + j]) continue;
            return false;
        }
        return true;
    }

    private int indexOf(byte[] subArray, int from) {
        block0: for (int i = from; i < this.limit - subArray.length + 1; ++i) {
            for (int j = 0; j < subArray.length; ++j) {
                if (subArray[j] != this.raw[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private int indexOf(byte b, int from) {
        for (int i = from; i < this.limit; ++i) {
            if (this.raw[i] != b) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return new String(this.raw, (int)this.offset, this.limit - this.offset, CHARSET);
    }

    private class QueryParamIterator
    implements Iterator<QueryParameter> {
        private int i = 0;

        private QueryParamIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < UrlParser.this.queryPositions.length && UrlParser.this.queryPositions[this.i] != 0;
        }

        @Override
        @NotNull
        public QueryParameter next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int record = UrlParser.this.queryPositions[this.i++];
            int keyStart = record & 0xFFFF;
            int keyEnd = record >>> 16;
            String key = new String(UrlParser.this.raw, keyStart, keyEnd - keyStart, CHARSET);
            String value = UrlParser.keyValueDecode(UrlParser.this.raw, keyEnd, UrlParser.this.limit);
            return new QueryParameter(key, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

