/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufStrings;
import io.activej.common.Checks;
import io.activej.common.exception.CloseException;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelInput;
import io.activej.csp.ChannelOutput;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;
import io.activej.http.HttpUtils;
import io.activej.http.WebSocket;
import io.activej.http.WebSocketConstants;
import io.activej.http.WebSocketException;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.Nullable;

final class WebSocketFramesToBufs
extends AbstractCommunicatingProcess
implements WithChannelTransformer<WebSocketFramesToBufs, WebSocket.Frame, ByteBuf> {
    private static final Boolean CHECK = Checks.isEnabled(WebSocketFramesToBufs.class);
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();
    private final boolean masked;
    private final SettablePromise<Void> closeSentPromise = new SettablePromise();
    private ChannelSupplier<WebSocket.Frame> input;
    private ChannelConsumer<ByteBuf> output;
    @Nullable
    private Promise<Void> pendingPromise;
    private boolean closing;
    private boolean waitingForFin;

    private WebSocketFramesToBufs(boolean masked) {
        this.masked = masked;
    }

    public static WebSocketFramesToBufs create(boolean masked) {
        return new WebSocketFramesToBufs(masked);
    }

    public ChannelInput<WebSocket.Frame> getInput() {
        return input -> {
            Checks.checkState((this.input == null ? 1 : 0) != 0, (Object)"Input already set");
            this.input = this.sanitize(input);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    public ChannelOutput<ByteBuf> getOutput() {
        return output -> {
            Checks.checkState((this.output == null ? 1 : 0) != 0, (Object)"Output already set");
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    protected void beforeProcess() {
        Checks.checkState((this.input != null ? 1 : 0) != 0, (Object)"Input was not set");
        Checks.checkState((this.output != null ? 1 : 0) != 0, (Object)"Output was not set");
    }

    protected void doProcess() {
        this.input.streamTo(ChannelConsumer.of(frame -> {
            if (CHECK.booleanValue()) {
                this.checkFrameOrder((WebSocket.Frame)frame);
            }
            return this.doAccept(this.encodeData((WebSocket.Frame)frame));
        })).then(() -> this.sendCloseFrame(WebSocketConstants.REGULAR_CLOSE)).whenResult(() -> this.completeProcess());
    }

    private ByteBuf doEncode(ByteBuf payload, WebSocketConstants.OpCode opCode, boolean isLastFrame) {
        int bufSize = payload.readRemaining();
        int lenSize = bufSize < 126 ? 1 : (bufSize < 65536 ? 3 : 9);
        ByteBuf framedBuf = ByteBufPool.allocate((int)(1 + lenSize + (this.masked ? 4 : 0) + bufSize));
        framedBuf.writeByte(isLastFrame ? (byte)(opCode.getCode() | 0x80) : opCode.getCode());
        if (lenSize == 1) {
            framedBuf.writeByte((byte)bufSize);
        } else if (lenSize == 3) {
            framedBuf.writeByte((byte)126);
            framedBuf.writeShort((short)bufSize);
        } else {
            framedBuf.writeByte((byte)127);
            framedBuf.writeLong((long)bufSize);
        }
        if (this.masked) {
            int idx = framedBuf.head() + 1;
            framedBuf.set(idx, (byte)(framedBuf.at(idx) | 0x80));
            byte[] mask = new byte[4];
            RANDOM.nextBytes(mask);
            framedBuf.put(mask);
            int i = 0;
            for (int head = payload.head(); head < payload.tail(); ++head) {
                payload.set(head, (byte)(payload.at(head) ^ mask[i++ % 4]));
            }
        }
        framedBuf.put(payload);
        payload.recycle();
        return framedBuf;
    }

    private ByteBuf encodeData(WebSocket.Frame frame) {
        return this.doEncode(frame.getPayload(), HttpUtils.frameToOpType(frame.getType()), frame.isLastFrame());
    }

    private ByteBuf encodePong(ByteBuf buf) {
        return this.doEncode(buf, WebSocketConstants.OpCode.OP_PONG, true);
    }

    private ByteBuf encodeClose(WebSocketException e) {
        Integer code = e.getCode();
        String reason = e.getReason();
        ByteBuf closePayload = ByteBufPool.allocate((int)(code == null ? 0 : 2 + reason.length()));
        if (code != null) {
            closePayload.writeShort(code.shortValue());
        }
        if (!reason.isEmpty()) {
            ByteBuf reasonBuf = ByteBufStrings.wrapUtf8((String)reason);
            closePayload.put(reasonBuf);
            reasonBuf.recycle();
        }
        return this.doEncode(closePayload, WebSocketConstants.OpCode.OP_CLOSE, true);
    }

    public Promise<Void> getCloseSentPromise() {
        return this.closeSentPromise;
    }

    private Promise<Void> doAccept(@Nullable ByteBuf buf) {
        if (this.closeSentPromise.isComplete()) {
            if (buf != null) {
                buf.recycle();
            }
            return Promise.ofException((Throwable)new CloseException());
        }
        if (this.pendingPromise == null) {
            this.pendingPromise = this.output.accept((Object)buf);
            return this.pendingPromise;
        }
        Promise<Void> pendingPromise = this.pendingPromise;
        this.pendingPromise = null;
        this.pendingPromise = pendingPromise.then(() -> this.output.accept((Object)buf));
        return this.pendingPromise;
    }

    void sendPong(ByteBuf payload) {
        this.doAccept(this.encodePong(payload));
    }

    Promise<Void> sendCloseFrame(WebSocketException e) {
        if (this.closing) {
            return Promise.complete();
        }
        this.closing = true;
        return this.doAccept(this.encodeClose(e == WebSocketConstants.STATUS_CODE_MISSING ? WebSocketConstants.EMPTY_CLOSE : e)).then(() -> this.doAccept(null)).whenComplete(() -> this.closeSentPromise.trySet(null));
    }

    private void checkFrameOrder(WebSocket.Frame frame) {
        WebSocket.Frame.FrameType type = frame.getType();
        if (!this.waitingForFin) {
            Checks.checkState((type == WebSocket.Frame.FrameType.TEXT || type == WebSocket.Frame.FrameType.BINARY ? 1 : 0) != 0);
            if (!frame.isLastFrame()) {
                this.waitingForFin = true;
            }
        } else {
            Checks.checkState((type == WebSocket.Frame.FrameType.CONTINUATION ? 1 : 0) != 0);
            if (frame.isLastFrame()) {
                this.waitingForFin = false;
            }
        }
    }

    protected void doClose(Throwable e) {
        WebSocketException exception;
        if (this.output == null || this.input == null) {
            return;
        }
        if (e instanceof WebSocketException) {
            WebSocketException wsEx = (WebSocketException)e;
            if (wsEx.canBeEchoed()) {
                exception = wsEx;
            } else {
                Integer code = wsEx.getCode();
                assert (code != null);
                exception = code == 1005 ? WebSocketConstants.EMPTY_CLOSE : (this.masked ? WebSocketConstants.GOING_AWAY : WebSocketConstants.SERVER_ERROR);
            }
        } else {
            exception = this.masked ? WebSocketConstants.GOING_AWAY : WebSocketConstants.SERVER_ERROR;
        }
        this.sendCloseFrame(exception);
    }
}

