/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.Checks;
import io.activej.common.exception.UncheckedException;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelConsumers;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.dsl.ChannelConsumerTransformer;
import io.activej.csp.dsl.ChannelSupplierTransformer;
import io.activej.csp.queue.ChannelZeroBuffer;
import io.activej.http.AbstractHttpConnection;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpHeaders;
import io.activej.http.HttpMessage;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.HttpUtils;
import io.activej.http.WebSocket;
import io.activej.http.WebSocketBufsToFrames;
import io.activej.http.WebSocketConstants;
import io.activej.http.WebSocketFramesToBufs;
import io.activej.http.WebSocketImpl;
import io.activej.promise.Promisable;
import io.activej.promise.Promise;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class WebSocketServlet
implements AsyncServlet {
    public WebSocketServlet() {
        Checks.checkState((boolean)WebSocket.ENABLED, (Object)"Web sockets are disabled by application settings");
    }

    protected Promisable<HttpResponse> onRequest(HttpRequest request) {
        return HttpResponse.ofCode(101);
    }

    protected abstract void onWebSocket(WebSocket var1);

    @Override
    @NotNull
    public final Promisable<HttpResponse> serve(@NotNull HttpRequest request) throws UncheckedException {
        return WebSocketServlet.validateHeaders(request).then(() -> WebSocketServlet.processAnswer(request)).then(answer -> {
            ChannelSupplier<ByteBuf> rawStream = request.getBodyStream();
            assert (rawStream != null);
            return this.onRequest(request).promise().whenException(e -> WebSocketServlet.recycleStream(rawStream)).map(response -> {
                if (response.getCode() != 101) {
                    WebSocketServlet.recycleStream(rawStream);
                    return response;
                }
                Checks.checkState((response.body == null && response.bodyStream == null ? 1 : 0) != 0, (Object)"Illegal body or stream");
                ChannelZeroBuffer buffer = new ChannelZeroBuffer();
                response.withBodyStream((ChannelSupplier<ByteBuf>)buffer.getSupplier()).withHeader(HttpHeaders.UPGRADE, "Websocket").withHeader(HttpHeaders.CONNECTION, "Upgrade").withHeader(HttpHeaders.SEC_WEBSOCKET_ACCEPT, (String)answer);
                WebSocketFramesToBufs encoder = WebSocketFramesToBufs.create(false);
                WebSocketBufsToFrames decoder = WebSocketBufsToFrames.create(request.maxBodySize, encoder::sendPong, ByteBuf::recycle, true);
                WebSocketServlet.bindWebSocketTransformers(rawStream, encoder, decoder);
                this.onWebSocket(new WebSocketImpl(request, (HttpResponse)response, (ChannelSupplier<WebSocket.Frame>)((ChannelSupplier)rawStream.transformWith((ChannelSupplierTransformer)decoder)), (ChannelConsumer<WebSocket.Frame>)((ChannelConsumer)buffer.getConsumer().transformWith((ChannelConsumerTransformer)encoder)), decoder::onProtocolError, request.maxBodySize));
                return response;
            });
        });
    }

    private static void bindWebSocketTransformers(ChannelSupplier<ByteBuf> rawStream, WebSocketFramesToBufs encoder, WebSocketBufsToFrames decoder) {
        encoder.getCloseSentPromise().then(decoder::getCloseReceivedPromise).whenException(arg_0 -> rawStream.closeEx(arg_0)).whenResult(arg_0 -> rawStream.closeEx(arg_0));
        decoder.getProcessCompletion().whenComplete(($, e) -> {
            if (e == null) {
                encoder.sendCloseFrame(WebSocketConstants.REGULAR_CLOSE);
            } else {
                encoder.closeEx(e);
            }
        });
    }

    private static boolean isUpgradeHeaderMissing(HttpMessage message) {
        String headerValue = message.getHeader(HttpHeaders.CONNECTION);
        if (headerValue != null) {
            for (String val : headerValue.split(",")) {
                if (!"upgrade".equalsIgnoreCase(val.trim())) continue;
                return false;
            }
        }
        return true;
    }

    private static Promise<Void> validateHeaders(HttpRequest request) {
        if (WebSocketServlet.isUpgradeHeaderMissing(request) || !Arrays.equals(AbstractHttpConnection.WEB_SOCKET_VERSION, request.getHeader(HttpHeaders.SEC_WEBSOCKET_VERSION, ByteBuf::getArray))) {
            return Promise.ofException((Throwable)WebSocketConstants.NOT_A_WEB_SOCKET_REQUEST);
        }
        return Promise.complete();
    }

    private static Promise<String> processAnswer(HttpRequest request) {
        String header = request.getHeader(HttpHeaders.SEC_WEBSOCKET_KEY);
        if (header == null) {
            return Promise.ofException((Throwable)WebSocketConstants.NOT_A_WEB_SOCKET_REQUEST);
        }
        return Promise.of((Object)HttpUtils.getWebSocketAnswer(header.trim()));
    }

    private static void recycleStream(ChannelSupplier<ByteBuf> rawStream) {
        rawStream.streamTo(ChannelConsumers.recycling());
    }
}

