/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.decoder;

import io.activej.common.collection.Either;
import io.activej.http.decoder.DecodeError;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@FunctionalInterface
public interface Mapper<T, V> {
    public Either<V, List<DecodeError>> map(T var1);

    public static <T, V> Mapper<T, V> of(Function<T, V> fn) {
        return value -> Either.left(fn.apply(value));
    }

    public static <T, V> Mapper<T, V> of(Function<T, V> fn, String message) {
        return value -> {
            try {
                return Either.left(fn.apply(value));
            }
            catch (Exception e) {
                return Either.right(Collections.singletonList(DecodeError.of(message, value)));
            }
        };
    }
}

