/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.loader;

import io.activej.bytebuf.ByteBuf;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.http.loader.StaticLoaderCache;
import io.activej.http.loader.StaticLoaderClassPath;
import io.activej.http.loader.StaticLoaderFileReader;
import io.activej.promise.Promise;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public interface StaticLoader {
    public Promise<ByteBuf> load(String var1);

    default public StaticLoader filter(Predicate<String> predicate) {
        return path -> predicate.test(path) ? this.load(path) : Promise.ofException((Throwable)new ResourceNotFoundException("Resource '" + path + "' has been filtered out"));
    }

    default public StaticLoader map(Function<String, String> fn) {
        return path -> this.load((String)fn.apply(path));
    }

    default public StaticLoader subdirectory(String subdirectory) {
        String folder = subdirectory.endsWith("/") ? subdirectory : subdirectory + '/';
        return this.map(name -> folder + name);
    }

    default public StaticLoader cached() {
        return StaticLoader.cacheOf(this);
    }

    default public StaticLoader cached(Map<String, byte[]> map) {
        return StaticLoader.cacheOf(this, map);
    }

    public static StaticLoader cacheOf(StaticLoader loader) {
        return StaticLoader.cacheOf(loader, new HashMap<String, byte[]>());
    }

    public static StaticLoader cacheOf(StaticLoader loader, Map<String, byte[]> map) {
        return StaticLoader.cacheOf(loader, map::get, map::put);
    }

    public static StaticLoader cacheOf(StaticLoader loader, Function<String, byte[]> get, BiConsumer<String, byte[]> put) {
        return new StaticLoaderCache(loader, get, put);
    }

    public static StaticLoader ofClassPath(@NotNull Executor executor, String root) {
        return StaticLoaderClassPath.create(executor, root);
    }

    public static StaticLoader ofClassPath(@NotNull Executor executor, ClassLoader classLoader, String root) {
        return StaticLoaderClassPath.create(executor, classLoader, root);
    }

    public static StaticLoader ofPath(@NotNull Executor executor, Path dir) {
        return StaticLoaderFileReader.create(executor, dir);
    }
}

