/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.loader;

import io.activej.bytebuf.ByteBuf;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.http.loader.StaticLoader;
import io.activej.promise.Promise;
import java.util.function.BiConsumer;
import java.util.function.Function;

class StaticLoaderCache
implements StaticLoader {
    public static final byte[] NOT_FOUND = new byte[0];
    private final StaticLoader resourceLoader;
    private final Function<String, byte[]> get;
    private final BiConsumer<String, byte[]> put;

    public StaticLoaderCache(StaticLoader resourceLoader, Function<String, byte[]> get, BiConsumer<String, byte[]> put) {
        this.resourceLoader = resourceLoader;
        this.get = get;
        this.put = put;
    }

    @Override
    public Promise<ByteBuf> load(String path) {
        byte[] bytes = this.get.apply(path);
        if (bytes == NOT_FOUND) {
            return Promise.ofException((Throwable)new ResourceNotFoundException("Could not find '" + path + '\''));
        }
        if (bytes != null) {
            return Promise.of((Object)ByteBuf.wrapForReading((byte[])bytes));
        }
        return this.doLoad(path);
    }

    private Promise<ByteBuf> doLoad(String path) {
        return this.resourceLoader.load(path).whenComplete((buf, e) -> {
            if (e == null) {
                this.put.accept(path, buf.getArray());
            } else if (e instanceof ResourceNotFoundException) {
                this.put.accept(path, NOT_FOUND);
            }
        });
    }
}

