/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.loader;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.csp.file.ChannelFileReader;
import io.activej.http.loader.ResourceIsADirectoryException;
import io.activej.http.loader.ResourceNotFoundException;
import io.activej.http.loader.StaticLoader;
import io.activej.promise.Promise;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.Executor;

class StaticLoaderFileReader
implements StaticLoader {
    private final Executor executor;
    private final Path root;

    private StaticLoaderFileReader(Executor executor, Path root) {
        this.executor = executor;
        this.root = root;
    }

    public static StaticLoader create(Executor executor, Path dir) {
        return new StaticLoaderFileReader(executor, dir);
    }

    @Override
    public Promise<ByteBuf> load(String path) {
        Path file = this.root.resolve(path).normalize();
        if (!file.startsWith(this.root)) {
            return Promise.ofException((Throwable)new ResourceNotFoundException("Could not find '" + path + '\''));
        }
        return Promise.ofBlockingCallable((Executor)this.executor, () -> {
            if (Files.isRegularFile(file, new LinkOption[0])) {
                return null;
            }
            if (Files.isDirectory(file, new LinkOption[0])) {
                throw new ResourceIsADirectoryException("Resource '" + path + "' is a directory");
            }
            throw new ResourceNotFoundException("Could not find '" + path + '\'');
        }).then(() -> ChannelFileReader.open((Executor)this.executor, (Path)file)).then(cfr -> cfr.toCollector(ByteBufs.collector()));
    }
}

