/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.session;

import io.activej.common.exception.UncheckedException;
import io.activej.http.AsyncServlet;
import io.activej.http.HttpRequest;
import io.activej.http.HttpResponse;
import io.activej.http.session.SessionStore;
import io.activej.promise.Promise;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class SessionServlet<T>
implements AsyncServlet {
    private final SessionStore<T> store;
    private final Function<HttpRequest, String> sessionIdExtractor;
    private final AsyncServlet publicServlet;
    private final AsyncServlet privateServlet;

    private SessionServlet(SessionStore<T> store, Function<HttpRequest, String> sessionIdExtractor, AsyncServlet publicServlet, AsyncServlet privateServlet) {
        this.store = store;
        this.sessionIdExtractor = sessionIdExtractor;
        this.publicServlet = publicServlet;
        this.privateServlet = privateServlet;
    }

    public static <T> SessionServlet<T> create(SessionStore<T> store, String sessionIdCookie, AsyncServlet publicServlet, AsyncServlet privateServlet) {
        return new SessionServlet<T>(store, request -> request.getCookie(sessionIdCookie), publicServlet, privateServlet);
    }

    public static <T> SessionServlet<T> create(SessionStore<T> store, Function<HttpRequest, String> sessionIdExtractor, AsyncServlet publicServlet, AsyncServlet privateServlet) {
        return new SessionServlet<T>(store, sessionIdExtractor, publicServlet, privateServlet);
    }

    @NotNull
    public Promise<HttpResponse> serve(@NotNull HttpRequest request) throws UncheckedException {
        String id = this.sessionIdExtractor.apply(request);
        if (id == null) {
            return this.publicServlet.serveAsync(request);
        }
        return this.store.get(id).then(sessionObject -> {
            if (sessionObject != null) {
                request.attach(sessionObject);
                return this.privateServlet.serveAsync(request);
            }
            return this.publicServlet.serveAsync(request);
        });
    }
}

