/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.session;

import io.activej.common.time.CurrentTimeProvider;
import io.activej.http.session.SessionStore;
import io.activej.promise.Promise;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class SessionStoreInMemory<T>
implements SessionStore<T> {
    private final Map<String, TWithTimestamp> store = new HashMap<String, TWithTimestamp>();
    @Nullable
    private Duration sessionLifetime;
    CurrentTimeProvider now = CurrentTimeProvider.ofSystem();

    private SessionStoreInMemory() {
    }

    public static <T> SessionStoreInMemory<T> create() {
        return new SessionStoreInMemory<T>();
    }

    public SessionStoreInMemory<T> withLifetime(Duration sessionLifetime) {
        this.sessionLifetime = sessionLifetime;
        return this;
    }

    @Override
    public Promise<Void> save(String sessionId, T sessionObject) {
        this.store.put(sessionId, new TWithTimestamp(sessionObject, this.now.currentTimeMillis()));
        return Promise.complete();
    }

    @Override
    public Promise<@Nullable T> get(String sessionId) {
        long timestamp = this.now.currentTimeMillis();
        TWithTimestamp tWithTimestamp = this.store.get(sessionId);
        if (tWithTimestamp == null) {
            return Promise.of(null);
        }
        if (this.sessionLifetime != null && tWithTimestamp.timestamp + this.sessionLifetime.toMillis() < timestamp) {
            this.store.remove(sessionId);
            return Promise.of(null);
        }
        tWithTimestamp.timestamp = timestamp;
        return Promise.of(tWithTimestamp.value);
    }

    @Override
    public Promise<Void> remove(String sessionId) {
        this.store.remove(sessionId);
        return Promise.complete();
    }

    @Override
    @Nullable
    public Duration getSessionLifetimeHint() {
        return this.sessionLifetime;
    }

    private class TWithTimestamp {
        final T value;
        long timestamp;

        public TWithTimestamp(T value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }
    }
}

