/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.stream;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelInput;
import io.activej.csp.ChannelOutput;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;

public final class BufsConsumerChunkedEncoder
extends AbstractCommunicatingProcess
implements WithChannelTransformer<BufsConsumerChunkedEncoder, ByteBuf, ByteBuf> {
    private static final byte[] LAST_CHUNK_BYTES = new byte[]{48, 13, 10, 13, 10};
    private ChannelSupplier<ByteBuf> input;
    private ChannelConsumer<ByteBuf> output;

    private BufsConsumerChunkedEncoder() {
    }

    public static BufsConsumerChunkedEncoder create() {
        return new BufsConsumerChunkedEncoder();
    }

    public ChannelInput<ByteBuf> getInput() {
        return input -> {
            Checks.checkState((this.input == null ? 1 : 0) != 0, (Object)"Input already set");
            this.input = this.sanitize(input);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    public ChannelOutput<ByteBuf> getOutput() {
        return output -> {
            Checks.checkState((this.output == null ? 1 : 0) != 0, (Object)"Output already set");
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    protected void beforeProcess() {
        Checks.checkState((this.input != null ? 1 : 0) != 0, (Object)"Input was not set");
        Checks.checkState((this.output != null ? 1 : 0) != 0, (Object)"Output was not set");
    }

    protected void doProcess() {
        this.input.filter(ByteBuf::canRead).streamTo(ChannelConsumer.of(buf -> this.output.accept((Object)BufsConsumerChunkedEncoder.encodeBuf(buf)))).then(() -> this.output.accept((Object)ByteBuf.wrapForReading((byte[])LAST_CHUNK_BYTES))).then(() -> this.output.acceptEndOfStream()).whenResult(() -> this.completeProcess());
    }

    private static ByteBuf encodeBuf(ByteBuf buf) {
        int bufSize = buf.readRemaining();
        char[] hexRepr = Integer.toHexString(bufSize).toCharArray();
        int hexLen = hexRepr.length;
        ByteBuf chunkBuf = ByteBufPool.allocate((int)(hexLen + 2 + bufSize + 2));
        for (int i = 0; i < hexLen; ++i) {
            chunkBuf.set(i, (byte)hexRepr[i]);
        }
        chunkBuf.set(hexLen, (byte)13);
        chunkBuf.set(hexLen + 1, (byte)10);
        chunkBuf.tail(hexLen + 2);
        chunkBuf.put(buf);
        buf.recycle();
        chunkBuf.writeByte((byte)13);
        chunkBuf.writeByte((byte)10);
        return chunkBuf;
    }

    protected void doClose(Throwable e) {
        this.input.closeEx(e);
        this.output.closeEx(e);
    }
}

