/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.stream;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelOutput;
import io.activej.csp.binary.BinaryChannelInput;
import io.activej.csp.binary.BinaryChannelSupplier;
import io.activej.csp.dsl.WithBinaryChannelInput;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;

public final class BufsConsumerDelimiter
extends AbstractCommunicatingProcess
implements WithChannelTransformer<BufsConsumerDelimiter, ByteBuf, ByteBuf>,
WithBinaryChannelInput<BufsConsumerDelimiter> {
    private ByteBufs bufs;
    private BinaryChannelSupplier input;
    private ChannelConsumer<ByteBuf> output;
    private int remaining;

    private BufsConsumerDelimiter(int remaining) {
        this.remaining = remaining;
    }

    public static BufsConsumerDelimiter create(int remaining) {
        Checks.checkState((remaining >= 0 ? 1 : 0) != 0, (Object)"Cannot create delimiter with number of remaining bytes that is less than 0");
        return new BufsConsumerDelimiter(remaining);
    }

    public BinaryChannelInput getInput() {
        return input -> {
            Checks.checkState((this.input == null ? 1 : 0) != 0, (Object)"Input already set");
            this.input = this.sanitize(input);
            this.bufs = input.getBufs();
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    public ChannelOutput<ByteBuf> getOutput() {
        return output -> {
            Checks.checkState((this.output == null ? 1 : 0) != 0, (Object)"Output already set");
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    protected void beforeProcess() {
        Checks.checkState((this.input != null ? 1 : 0) != 0, (Object)"Input was not set");
        Checks.checkState((this.output != null ? 1 : 0) != 0, (Object)"Output was not set");
    }

    protected void doProcess() {
        if (this.remaining == 0) {
            this.input.endOfStream().then(() -> this.output.acceptEndOfStream()).whenResult(() -> this.completeProcess());
            return;
        }
        ByteBufs outputBufs = new ByteBufs();
        this.remaining -= this.bufs.drainTo(outputBufs, this.remaining);
        this.output.acceptAll(outputBufs.asIterator()).whenResult(() -> {
            if (this.remaining != 0) {
                this.input.needMoreData().whenResult(this::doProcess);
            } else {
                this.input.endOfStream().then(() -> this.output.acceptEndOfStream()).whenResult(() -> this.completeProcess());
            }
        });
    }

    protected void doClose(Throwable e) {
        this.input.closeEx(e);
        this.output.closeEx(e);
    }
}

