/*
 * Decompiled with CFR 0.152.
 */
package io.activej.http.stream;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelInput;
import io.activej.csp.ChannelOutput;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.dsl.WithChannelTransformer;
import io.activej.csp.process.AbstractCommunicatingProcess;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.jetbrains.annotations.NotNull;

public final class BufsConsumerGzipDeflater
extends AbstractCommunicatingProcess
implements WithChannelTransformer<BufsConsumerGzipDeflater, ByteBuf, ByteBuf> {
    public static final int DEFAULT_MAX_BUF_SIZE = 16384;
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private static final int GZIP_FOOTER_SIZE = 8;
    private final CRC32 crc32 = new CRC32();
    private Deflater deflater = new Deflater(-1, true);
    private int maxBufSize = 16384;
    private ChannelSupplier<ByteBuf> input;
    private ChannelConsumer<ByteBuf> output;

    private BufsConsumerGzipDeflater() {
    }

    public static BufsConsumerGzipDeflater create() {
        return new BufsConsumerGzipDeflater();
    }

    public BufsConsumerGzipDeflater withDeflater(@NotNull Deflater deflater) {
        this.deflater = deflater;
        return this;
    }

    public BufsConsumerGzipDeflater withMaxBufSize(MemSize maxBufSize) {
        Checks.checkArgument((maxBufSize.compareTo(MemSize.ZERO) > 0 ? 1 : 0) != 0, (Object)"Cannot use buf size that is less than 0");
        this.maxBufSize = maxBufSize.toInt();
        return this;
    }

    public ChannelInput<ByteBuf> getInput() {
        return input -> {
            Checks.checkState((this.input == null ? 1 : 0) != 0, (Object)"Input already set");
            this.input = this.sanitize(input);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
            return this.getProcessCompletion();
        };
    }

    public ChannelOutput<ByteBuf> getOutput() {
        return output -> {
            Checks.checkState((this.output == null ? 1 : 0) != 0, (Object)"Output already set");
            this.output = this.sanitize(output);
            if (this.input != null && this.output != null) {
                this.startProcess();
            }
        };
    }

    protected void beforeProcess() {
        Checks.checkState((this.input != null ? 1 : 0) != 0, (Object)"Input was not set");
        Checks.checkState((this.output != null ? 1 : 0) != 0, (Object)"Output was not set");
    }

    protected void doProcess() {
        this.writeHeader();
    }

    private void writeHeader() {
        this.output.accept((Object)ByteBuf.wrapForReading((byte[])GZIP_HEADER)).whenResult(this::writeBody);
    }

    private void writeBody() {
        this.input.streamTo(ChannelConsumer.of(buf -> {
            this.crc32.update(buf.array(), buf.head(), buf.readRemaining());
            this.deflater.setInput(buf.array(), buf.head(), buf.readRemaining());
            ByteBufs bufs = this.deflate();
            buf.recycle();
            return this.output.acceptAll(bufs.asIterator());
        })).whenResult(this::writeFooter);
    }

    private void writeFooter() {
        this.deflater.finish();
        ByteBufs bufs = this.deflate();
        ByteBuf footer = ByteBufPool.allocate((int)8);
        footer.writeInt(Integer.reverseBytes((int)this.crc32.getValue()));
        footer.writeInt(Integer.reverseBytes(this.deflater.getTotalIn()));
        bufs.add(footer);
        this.output.acceptAll(bufs.asIterator()).then(() -> this.output.acceptEndOfStream()).whenResult(() -> this.completeProcess());
    }

    private ByteBufs deflate() {
        ByteBuf out;
        int len;
        ByteBufs bufs = new ByteBufs();
        while ((len = this.deflater.deflate((out = ByteBufPool.allocate((int)this.maxBufSize)).array(), out.tail(), out.writeRemaining())) > 0) {
            out.tail(len);
            bufs.add(out);
        }
        out.recycle();
        return bufs;
    }

    protected void doClose(Throwable e) {
        this.deflater.end();
        this.input.closeEx(e);
        this.output.closeEx(e);
    }
}

