/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net;

import io.activej.common.Checks;
import io.activej.common.api.WithInitializer;
import io.activej.common.inspector.BaseInspector;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.jmx.EventloopJmxBeanEx;
import io.activej.eventloop.net.ServerSocketSettings;
import io.activej.eventloop.net.SocketSettings;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.net.EventloopServer;
import io.activej.net.PrimaryServer;
import io.activej.net.WorkerServer;
import io.activej.net.socket.tcp.AsyncTcpSocket;
import io.activej.net.socket.tcp.AsyncTcpSocketNio;
import io.activej.net.socket.tcp.AsyncTcpSocketSsl;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer<Self extends AbstractServer<Self>>
implements EventloopServer,
WorkerServer,
WithInitializer<Self>,
EventloopJmxBeanEx {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final boolean CHECK = Checks.isEnabled(AbstractServer.class);
    @NotNull
    protected final Eventloop eventloop;
    public static final ServerSocketSettings DEFAULT_SERVER_SOCKET_SETTINGS = ServerSocketSettings.create((int)16384);
    public static final SocketSettings DEFAULT_SOCKET_SETTINGS = SocketSettings.createDefault();
    protected ServerSocketSettings serverSocketSettings = DEFAULT_SERVER_SOCKET_SETTINGS;
    protected SocketSettings socketSettings = DEFAULT_SOCKET_SETTINGS;
    protected boolean acceptOnce;
    private AcceptFilter acceptFilter;
    protected List<InetSocketAddress> listenAddresses = new ArrayList<InetSocketAddress>();
    private SSLContext sslContext;
    private Executor sslExecutor;
    protected List<InetSocketAddress> sslListenAddresses = new ArrayList<InetSocketAddress>();
    private boolean running = false;
    private List<ServerSocketChannel> serverSocketChannels;
    private static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
    AbstractServer<?> acceptServer = this;
    @Nullable
    private AsyncTcpSocketNio.Inspector socketInspector;
    @Nullable
    private AsyncTcpSocketNio.Inspector socketSslInspector;
    private final EventStats accepts = EventStats.create((Duration)SMOOTHING_WINDOW);
    private final EventStats acceptsSsl = EventStats.create((Duration)SMOOTHING_WINDOW);
    private final EventStats filteredAccepts = EventStats.create((Duration)SMOOTHING_WINDOW);

    protected AbstractServer(@NotNull Eventloop eventloop) {
        this.eventloop = eventloop;
    }

    public final Self withAcceptFilter(AcceptFilter acceptFilter) {
        this.acceptFilter = acceptFilter;
        return (Self)this;
    }

    public final Self withServerSocketSettings(ServerSocketSettings serverSocketSettings) {
        this.serverSocketSettings = serverSocketSettings;
        return (Self)this;
    }

    public final Self withSocketSettings(SocketSettings socketSettings) {
        this.socketSettings = socketSettings;
        return (Self)this;
    }

    public final Self withListenAddresses(List<InetSocketAddress> addresses) {
        this.listenAddresses = addresses;
        return (Self)this;
    }

    public final Self withListenAddresses(InetSocketAddress ... addresses) {
        return this.withListenAddresses(Arrays.asList(addresses));
    }

    public final Self withListenAddress(InetSocketAddress address) {
        return this.withListenAddresses(Collections.singletonList(address));
    }

    public final Self withListenPort(int port) {
        return this.withListenAddress(new InetSocketAddress(port));
    }

    public final Self withSslListenAddresses(SSLContext sslContext, Executor sslExecutor, List<InetSocketAddress> addresses) {
        this.sslContext = sslContext;
        this.sslExecutor = sslExecutor;
        this.sslListenAddresses = addresses;
        return (Self)this;
    }

    public final Self withSslListenAddresses(SSLContext sslContext, Executor sslExecutor, InetSocketAddress ... addresses) {
        return this.withSslListenAddresses(sslContext, sslExecutor, Arrays.asList(addresses));
    }

    public final Self withSslListenAddress(SSLContext sslContext, Executor sslExecutor, InetSocketAddress address) {
        return this.withSslListenAddresses(sslContext, sslExecutor, Collections.singletonList(address));
    }

    public final Self withSslListenPort(SSLContext sslContext, Executor sslExecutor, int port) {
        return this.withSslListenAddress(sslContext, sslExecutor, new InetSocketAddress(port));
    }

    public final Self withAcceptOnce() {
        return this.withAcceptOnce(true);
    }

    public final Self withAcceptOnce(boolean acceptOnce) {
        this.acceptOnce = acceptOnce;
        return (Self)this;
    }

    public final Self withSocketInspector(AsyncTcpSocketNio.Inspector socketInspector) {
        this.socketInspector = socketInspector;
        return (Self)this;
    }

    public final Self withSocketSslInspector(AsyncTcpSocketNio.Inspector socketSslInspector) {
        this.socketSslInspector = socketSslInspector;
        return (Self)this;
    }

    public final Self withLogger(Logger logger) {
        this.logger = logger;
        return (Self)this;
    }

    protected abstract void serve(AsyncTcpSocket var1, InetAddress var2);

    protected void onListen() {
    }

    protected void onClose(SettablePromise<Void> cb) {
        cb.set(null);
    }

    protected void onAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetAddress remoteAddress, boolean ssl) {
    }

    protected void onFilteredAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetAddress remoteAddress, boolean ssl) {
    }

    @Override
    public final void listen() throws IOException {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        if (this.running) {
            return;
        }
        this.running = true;
        this.onListen();
        this.serverSocketChannels = new ArrayList<ServerSocketChannel>();
        if (this.listenAddresses != null && !this.listenAddresses.isEmpty()) {
            this.listenAddresses(this.listenAddresses, false);
            this.logger.info("Listening on {}: {}", this.listenAddresses, (Object)this);
        }
        if (this.sslListenAddresses != null && !this.sslListenAddresses.isEmpty()) {
            this.listenAddresses(this.sslListenAddresses, true);
            this.logger.info("Listening with SSL on {}: {}", this.sslListenAddresses, (Object)this);
        }
    }

    private void listenAddresses(List<InetSocketAddress> addresses, boolean ssl) throws IOException {
        for (InetSocketAddress address : addresses) {
            try {
                this.serverSocketChannels.add(this.eventloop.listen(address, this.serverSocketSettings, channel -> this.doAccept((SocketChannel)channel, address, ssl)));
            }
            catch (IOException e) {
                this.logger.error("Can't listen on [" + address + "]: " + this, (Throwable)e);
                this.close();
                throw e;
            }
        }
    }

    @Override
    public final Promise<?> close() {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Cannot close server from different thread");
        }
        if (!this.running) {
            return Promise.complete();
        }
        this.running = false;
        this.closeServerSockets();
        return Promise.ofCallback(this::onClose).whenComplete(($, e) -> {
            if (e == null) {
                this.logger.info("Server closed: {}", (Object)this);
            } else {
                this.logger.error("Server closed exceptionally: " + this, e);
            }
        });
    }

    public final Future<?> closeFuture() {
        return this.eventloop.submit(this::close);
    }

    public final boolean isRunning() {
        return this.running;
    }

    protected void closeServerSockets() {
        if (this.serverSocketChannels == null || this.serverSocketChannels.isEmpty()) {
            return;
        }
        Iterator<ServerSocketChannel> it = this.serverSocketChannels.iterator();
        while (it.hasNext()) {
            ServerSocketChannel serverSocketChannel = it.next();
            if (serverSocketChannel == null) continue;
            this.eventloop.closeChannel((SelectableChannel)serverSocketChannel, serverSocketChannel.keyFor(this.eventloop.getSelector()));
            it.remove();
        }
    }

    protected WorkerServer getWorkerServer() {
        return this;
    }

    protected AsyncTcpSocketNio.Inspector getSocketInspector(InetAddress remoteAddress, InetSocketAddress localAddress, boolean ssl) {
        return ssl ? this.socketSslInspector : this.socketInspector;
    }

    private void doAccept(SocketChannel channel, InetSocketAddress localAddress, boolean ssl) {
        InetSocketAddress remoteSocketAddress;
        try {
            remoteSocketAddress = (InetSocketAddress)channel.getRemoteAddress();
        }
        catch (IOException e) {
            this.eventloop.closeChannel((SelectableChannel)channel, null);
            return;
        }
        InetAddress remoteAddress = remoteSocketAddress.getAddress();
        if (this.acceptFilter != null && this.acceptFilter.filterAccept(channel, localAddress, remoteAddress, ssl)) {
            this.filteredAccepts.recordEvent();
            this.onFilteredAccept(channel, localAddress, remoteAddress, ssl);
            this.eventloop.closeChannel((SelectableChannel)channel, null);
            return;
        }
        WorkerServer workerServer = this.getWorkerServer();
        Eventloop workerServerEventloop = workerServer.getEventloop();
        if (workerServerEventloop == this.eventloop) {
            workerServer.doAccept(channel, localAddress, remoteSocketAddress, ssl, this.socketSettings);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("received connection from [{}]{}: {}", new Object[]{remoteAddress, ssl ? " over SSL" : "", this});
            }
            this.accepts.recordEvent();
            if (ssl) {
                this.acceptsSsl.recordEvent();
            }
            this.onAccept(channel, localAddress, remoteAddress, ssl);
            workerServerEventloop.execute(() -> workerServer.doAccept(channel, localAddress, remoteSocketAddress, ssl, this.socketSettings));
        }
        if (this.acceptOnce) {
            this.closeServerSockets();
        }
    }

    @Override
    public final void doAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetSocketAddress remoteSocketAddress, boolean ssl, SocketSettings socketSettings) {
        AsyncTcpSocketNio asyncTcpSocket;
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        this.accepts.recordEvent();
        if (ssl) {
            this.acceptsSsl.recordEvent();
        }
        InetAddress remoteAddress = remoteSocketAddress.getAddress();
        this.onAccept(socketChannel, localAddress, remoteAddress, ssl);
        try {
            AsyncTcpSocketNio.Inspector inspector;
            AsyncTcpSocketNio socketNio = AsyncTcpSocketNio.wrapChannel(this.eventloop, socketChannel, remoteSocketAddress, socketSettings);
            AsyncTcpSocketNio.Inspector inspector2 = inspector = ssl ? this.socketSslInspector : this.socketInspector;
            if (inspector != null) {
                inspector.onConnect(socketNio);
                socketNio.setInspector(inspector);
            }
            asyncTcpSocket = socketNio;
        }
        catch (IOException e) {
            this.logger.warn("Failed to wrap channel {}", (Object)socketChannel, (Object)e);
            this.eventloop.closeChannel((SelectableChannel)socketChannel, null);
            return;
        }
        asyncTcpSocket = ssl ? AsyncTcpSocketSsl.wrapServerSocket(asyncTcpSocket, this.sslContext, this.sslExecutor) : asyncTcpSocket;
        this.serve(asyncTcpSocket, remoteAddress);
    }

    public ServerSocketSettings getServerSocketSettings() {
        return this.serverSocketSettings;
    }

    public List<InetSocketAddress> getListenAddresses() {
        return this.listenAddresses;
    }

    public List<InetSocketAddress> getSslListenAddresses() {
        return this.sslListenAddresses;
    }

    public SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    @Override
    @NotNull
    public final Eventloop getEventloop() {
        return this.eventloop;
    }

    @JmxAttribute(extraSubAttributes={"totalCount"})
    @Nullable
    public final EventStats getAccepts() {
        return this.acceptServer.listenAddresses.isEmpty() ? null : this.accepts;
    }

    @JmxAttribute
    @Nullable
    public final EventStats getAcceptsSsl() {
        return this.acceptServer.sslListenAddresses.isEmpty() ? null : this.acceptsSsl;
    }

    @JmxAttribute
    @Nullable
    public final EventStats getFilteredAccepts() {
        return this.acceptFilter == null ? null : this.filteredAccepts;
    }

    @JmxAttribute
    @Nullable
    public final AsyncTcpSocketNio.JmxInspector getSocketStats() {
        return this instanceof PrimaryServer || this.acceptServer.listenAddresses.isEmpty() ? null : (AsyncTcpSocketNio.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketInspector, AsyncTcpSocketNio.JmxInspector.class);
    }

    @JmxAttribute
    @Nullable
    public final AsyncTcpSocketNio.JmxInspector getSocketStatsSsl() {
        return this instanceof PrimaryServer || this.acceptServer.sslListenAddresses.isEmpty() ? null : (AsyncTcpSocketNio.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketSslInspector, AsyncTcpSocketNio.JmxInspector.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + (this.listenAddresses.isEmpty() ? "" : "listenAddresses=" + this.listenAddresses) + (this.sslListenAddresses.isEmpty() ? "" : ", sslListenAddresses=" + this.sslListenAddresses) + (this.acceptOnce ? ", acceptOnce" : "") + '}';
    }

    @FunctionalInterface
    public static interface AcceptFilter {
        public boolean filterAccept(SocketChannel var1, InetSocketAddress var2, InetAddress var3, boolean var4);
    }
}

