/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net.socket.tcp;

import io.activej.async.callback.Callback;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.Utils;
import io.activej.common.exception.AsyncTimeoutException;
import io.activej.common.exception.CloseException;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.inspector.BaseInspector;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.NioChannelEventHandler;
import io.activej.eventloop.net.SocketSettings;
import io.activej.eventloop.schedule.ScheduledRunnable;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.ValueStats;
import io.activej.net.socket.tcp.AsyncTcpSocket;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsyncTcpSocketNio
implements AsyncTcpSocket,
NioChannelEventHandler {
    private static final boolean CHECK = Checks.isEnabled(AsyncTcpSocketNio.class);
    private static final int DEBUG_READ_OFFSET = ApplicationSettings.getInt(AsyncTcpSocketNio.class, (String)"debugReadOffset", (int)0);
    public static final int DEFAULT_READ_BUFFER_SIZE = ApplicationSettings.getMemSize(AsyncTcpSocketNio.class, (String)"readBufferSize", (MemSize)MemSize.kilobytes((long)16L)).toInt();
    public static final int NO_TIMEOUT = 0;
    private static final AtomicInteger CONNECTION_COUNT = new AtomicInteger(0);
    private final Eventloop eventloop;
    private final InetSocketAddress remoteAddress;
    @Nullable
    private SocketChannel channel;
    @Nullable
    private ByteBuf readBuf;
    private boolean readEndOfStream;
    @Nullable
    private ByteBuf writeBuf;
    private boolean writeEndOfStream;
    @Nullable
    private SettablePromise<ByteBuf> read;
    @Nullable
    private SettablePromise<Void> write;
    private SelectionKey key;
    private byte ops;
    private int readTimeout = 0;
    private int writeTimeout = 0;
    private int readBufferSize = DEFAULT_READ_BUFFER_SIZE;
    @Nullable
    private ScheduledRunnable scheduledReadTimeout;
    @Nullable
    private ScheduledRunnable scheduledWriteTimeout;
    @Nullable
    private Inspector inspector;
    @Nullable
    private Object userData;

    public static AsyncTcpSocketNio wrapChannel(Eventloop eventloop, SocketChannel socketChannel, @NotNull InetSocketAddress remoteAddress, @Nullable SocketSettings socketSettings) throws IOException {
        AsyncTcpSocketNio asyncTcpSocket = new AsyncTcpSocketNio(eventloop, socketChannel, remoteAddress);
        if (socketSettings == null) {
            return asyncTcpSocket;
        }
        socketSettings.applySettings(socketChannel);
        if (socketSettings.hasImplReadTimeout()) {
            asyncTcpSocket.readTimeout = (int)socketSettings.getImplReadTimeoutMillis();
        }
        if (socketSettings.hasImplWriteTimeout()) {
            asyncTcpSocket.writeTimeout = (int)socketSettings.getImplWriteTimeoutMillis();
        }
        if (socketSettings.hasReadBufferSize()) {
            asyncTcpSocket.readBufferSize = socketSettings.getImplReadBufferSizeBytes();
        }
        return asyncTcpSocket;
    }

    public static AsyncTcpSocketNio wrapChannel(Eventloop eventloop, SocketChannel socketChannel, @Nullable SocketSettings socketSettings) throws IOException {
        return AsyncTcpSocketNio.wrapChannel(eventloop, socketChannel, (InetSocketAddress)socketChannel.getRemoteAddress(), socketSettings);
    }

    public static Promise<AsyncTcpSocketNio> connect(InetSocketAddress address) {
        return AsyncTcpSocketNio.connect(address, null, null);
    }

    public static Promise<AsyncTcpSocketNio> connect(InetSocketAddress address, @Nullable Duration duration, @Nullable SocketSettings socketSettings) {
        return AsyncTcpSocketNio.connect(address, duration == null ? 0L : duration.toMillis(), socketSettings);
    }

    public static Promise<AsyncTcpSocketNio> connect(InetSocketAddress address, long timeout, @Nullable SocketSettings socketSettings) {
        Eventloop eventloop = Eventloop.getCurrentEventloop();
        return Promise.ofCallback(cb -> eventloop.connect((SocketAddress)address, timeout, (Callback)cb)).then(channel -> {
            try {
                return Promise.of((Object)AsyncTcpSocketNio.wrapChannel(eventloop, channel, address, socketSettings));
            }
            catch (IOException e) {
                eventloop.closeChannel((SelectableChannel)channel, null);
                return Promise.ofException((Throwable)e);
            }
        });
    }

    public void setInspector(@Nullable Inspector inspector) {
        this.inspector = inspector;
    }

    private AsyncTcpSocketNio(Eventloop eventloop, @NotNull SocketChannel socketChannel, InetSocketAddress remoteAddress) {
        this.eventloop = eventloop;
        this.channel = socketChannel;
        this.remoteAddress = remoteAddress;
    }

    public static int getConnectionCount() {
        return CONNECTION_COUNT.get();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Nullable
    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(@Nullable Object userData) {
        this.userData = userData;
    }

    private void scheduleReadTimeout() {
        assert (this.scheduledReadTimeout == null && this.readTimeout != 0);
        this.scheduledReadTimeout = this.eventloop.delayBackground((long)this.readTimeout, () -> {
            if (this.inspector != null) {
                this.inspector.onReadTimeout(this);
            }
            this.scheduledReadTimeout = null;
            this.closeEx((Throwable)new AsyncTimeoutException("Timed out"));
        });
    }

    private void scheduleWriteTimeout() {
        assert (this.scheduledWriteTimeout == null && this.writeTimeout != 0);
        this.scheduledWriteTimeout = this.eventloop.delayBackground((long)this.writeTimeout, () -> {
            if (this.inspector != null) {
                this.inspector.onWriteTimeout(this);
            }
            this.scheduledWriteTimeout = null;
            this.closeEx((Throwable)new AsyncTimeoutException("Timed out"));
        });
    }

    private void updateInterests() {
        assert (!this.isClosed() && this.ops >= 0);
        byte newOps = (byte)((this.readBuf == null && !this.readEndOfStream ? 1 : 0) | (this.writeBuf == null || this.writeEndOfStream ? 0 : 4));
        if (this.key == null) {
            this.ops = newOps;
            try {
                this.key = this.channel.register(this.eventloop.ensureSelector(), this.ops, this);
                CONNECTION_COUNT.incrementAndGet();
            }
            catch (ClosedChannelException e) {
                this.closeEx(e);
            }
        } else if (this.ops != newOps) {
            this.ops = newOps;
            this.key.interestOps(this.ops);
        }
    }

    @Override
    @NotNull
    public Promise<ByteBuf> read() {
        SettablePromise read;
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
        }
        if (this.isClosed()) {
            return Promise.ofException((Throwable)new CloseException());
        }
        this.read = null;
        if (this.readBuf != null || this.readEndOfStream) {
            ByteBuf readBuf = this.readBuf;
            this.readBuf = null;
            return Promise.of((Object)readBuf);
        }
        this.read = read = new SettablePromise();
        if (this.scheduledReadTimeout == null && this.readTimeout != 0) {
            this.scheduleReadTimeout();
        }
        if (this.ops >= 0) {
            this.updateInterests();
        }
        return read;
    }

    public void onReadReady() {
        this.ops = (byte)(this.ops | 0x80);
        try {
            this.doRead();
        }
        catch (IOException e) {
            this.closeEx(e);
            return;
        }
        if (this.read != null && (this.readBuf != null || this.readEndOfStream)) {
            SettablePromise<@Nullable ByteBuf> read = this.read;
            ByteBuf readBuf = this.readBuf;
            this.read = null;
            this.readBuf = null;
            read.set((Object)readBuf);
        }
        if (this.isClosed()) {
            return;
        }
        this.ops = (byte)(this.ops & 0x7F);
        this.updateInterests();
    }

    private void doRead() throws IOException {
        int numRead;
        ByteBuf buf;
        assert (this.channel != null);
        if (DEBUG_READ_OFFSET == 0) {
            buf = ByteBufPool.allocate((int)this.readBufferSize);
        } else {
            Checks.checkState((DEBUG_READ_OFFSET > 0 ? 1 : 0) != 0);
            buf = ByteBufPool.allocate((int)this.readBufferSize);
            buf.tail(DEBUG_READ_OFFSET);
            buf.head(DEBUG_READ_OFFSET);
        }
        ByteBuffer buffer = buf.toWriteByteBuffer();
        try {
            numRead = this.channel.read(buffer);
            buf.ofWriteByteBuffer(buffer);
        }
        catch (IOException e) {
            buf.recycle();
            if (this.inspector != null) {
                this.inspector.onReadError(this, e);
            }
            throw e;
        }
        if (numRead == 0) {
            if (this.inspector != null) {
                this.inspector.onRead(this, buf);
            }
            buf.recycle();
            return;
        }
        this.scheduledReadTimeout = (ScheduledRunnable)Utils.nullify((Object)this.scheduledReadTimeout, ScheduledRunnable::cancel);
        if (numRead == -1) {
            buf.recycle();
            if (this.inspector != null) {
                this.inspector.onReadEndOfStream(this);
            }
            this.readEndOfStream = true;
            if (this.writeEndOfStream && this.writeBuf == null) {
                this.doClose();
            }
            return;
        }
        if (this.inspector != null) {
            this.inspector.onRead(this, buf);
        }
        if (this.readBuf == null) {
            this.readBuf = buf;
        } else {
            this.readBuf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.readBuf, (int)buf.readRemaining());
            this.readBuf.put(buf.array(), buf.head(), buf.readRemaining());
            buf.recycle();
        }
    }

    @Override
    @NotNull
    public Promise<Void> write(@Nullable ByteBuf buf) {
        SettablePromise write;
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
            Checks.checkState((!this.writeEndOfStream ? 1 : 0) != 0, (Object)"End of stream has already been sent");
        }
        if (this.isClosed()) {
            if (buf != null) {
                buf.recycle();
            }
            return Promise.ofException((Throwable)new CloseException());
        }
        this.writeEndOfStream |= buf == null;
        if (this.writeBuf == null) {
            if (buf != null && !buf.canRead()) {
                buf.recycle();
                return Promise.complete();
            }
            this.writeBuf = buf;
        } else if (buf != null) {
            this.writeBuf = ByteBufPool.ensureWriteRemaining((ByteBuf)this.writeBuf, (int)buf.readRemaining());
            this.writeBuf.put(buf.array(), buf.head(), buf.readRemaining());
            buf.recycle();
        }
        if (this.write != null) {
            return this.write;
        }
        try {
            this.doWrite();
        }
        catch (IOException e) {
            this.closeEx(e);
            return Promise.ofException((Throwable)e);
        }
        if (this.writeBuf == null) {
            return Promise.complete();
        }
        this.write = write = new SettablePromise();
        if (this.scheduledWriteTimeout == null && this.writeTimeout != 0) {
            this.scheduleWriteTimeout();
        }
        if (this.ops >= 0) {
            this.updateInterests();
        }
        return write;
    }

    @Override
    public boolean isReadAvailable() {
        return this.readBuf != null;
    }

    public void onWriteReady() {
        assert (this.write != null);
        this.ops = (byte)(this.ops | 0x80);
        try {
            this.doWrite();
        }
        catch (IOException e) {
            this.closeEx(e);
            return;
        }
        if (this.writeBuf == null) {
            SettablePromise<@Nullable Void> write = this.write;
            this.write = null;
            write.set(null);
        }
        if (this.isClosed()) {
            return;
        }
        this.ops = (byte)(this.ops & 0x7F);
        this.updateInterests();
    }

    private void doWrite() throws IOException {
        assert (this.channel != null);
        if (this.writeBuf != null) {
            ByteBuf buf = this.writeBuf;
            ByteBuffer buffer = buf.toReadByteBuffer();
            try {
                this.channel.write(buffer);
            }
            catch (IOException e) {
                if (this.inspector != null) {
                    this.inspector.onWriteError(this, e);
                }
                throw e;
            }
            if (this.inspector != null) {
                this.inspector.onWrite(this, buf, buffer.position() - buf.head());
            }
            buf.ofReadByteBuffer(buffer);
            if (buf.canRead()) {
                return;
            }
            buf.recycle();
            this.writeBuf = null;
        }
        this.scheduledWriteTimeout = (ScheduledRunnable)Utils.nullify((Object)this.scheduledWriteTimeout, ScheduledRunnable::cancel);
        if (this.writeEndOfStream) {
            if (this.readEndOfStream) {
                this.doClose();
            } else {
                this.channel.shutdownOutput();
            }
        }
    }

    public void closeEx(@NotNull Throwable e) {
        if (CHECK) {
            Checks.checkState((boolean)this.eventloop.inEventloopThread());
        }
        if (this.isClosed()) {
            return;
        }
        this.doClose();
        this.readBuf = (ByteBuf)Utils.nullify((Object)this.readBuf, ByteBuf::recycle);
        this.writeBuf = (ByteBuf)Utils.nullify((Object)this.writeBuf, ByteBuf::recycle);
        this.scheduledReadTimeout = (ScheduledRunnable)Utils.nullify((Object)this.scheduledReadTimeout, ScheduledRunnable::cancel);
        this.scheduledWriteTimeout = (ScheduledRunnable)Utils.nullify((Object)this.scheduledWriteTimeout, ScheduledRunnable::cancel);
        this.read = (SettablePromise)Utils.nullify(this.read, SettablePromise::setException, (Object)e);
        this.write = (SettablePromise)Utils.nullify(this.write, SettablePromise::setException, (Object)e);
    }

    private void doClose() {
        this.eventloop.closeChannel((SelectableChannel)this.channel, this.key);
        this.channel = null;
        CONNECTION_COUNT.decrementAndGet();
        if (this.inspector != null) {
            this.inspector.onDisconnect(this);
        }
    }

    @Override
    public boolean isClosed() {
        return this.channel == null;
    }

    @Nullable
    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public String toString() {
        return "AsyncTcpSocketImpl{channel=" + (this.channel != null ? this.channel : "") + ", readBuf=" + this.readBuf + ", writeBuf=" + this.writeBuf + ", readEndOfStream=" + this.readEndOfStream + ", writeEndOfStream=" + this.writeEndOfStream + ", read=" + this.read + ", write=" + this.write + ", ops=" + this.ops + "}";
    }

    public static interface Inspector
    extends BaseInspector<Inspector> {
        public void onConnect(AsyncTcpSocketNio var1);

        public void onReadTimeout(AsyncTcpSocketNio var1);

        public void onRead(AsyncTcpSocketNio var1, ByteBuf var2);

        public void onReadEndOfStream(AsyncTcpSocketNio var1);

        public void onReadError(AsyncTcpSocketNio var1, IOException var2);

        public void onWriteTimeout(AsyncTcpSocketNio var1);

        public void onWrite(AsyncTcpSocketNio var1, ByteBuf var2, int var3);

        public void onWriteError(AsyncTcpSocketNio var1, IOException var2);

        public void onDisconnect(AsyncTcpSocketNio var1);
    }

    public static class JmxInspector
    extends AbstractInspector<Inspector>
    implements Inspector {
        public static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        private final EventStats connects = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ValueStats reads = ValueStats.create((Duration)SMOOTHING_WINDOW).withUnit("bytes").withRate();
        private final EventStats readEndOfStreams = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ExceptionStats readErrors = ExceptionStats.create();
        private final EventStats readTimeouts = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final ValueStats writes = ValueStats.create((Duration)SMOOTHING_WINDOW).withUnit("bytes").withRate();
        private final ExceptionStats writeErrors = ExceptionStats.create();
        private final EventStats writeTimeouts = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats writeOverloaded = EventStats.create((Duration)SMOOTHING_WINDOW);
        private final EventStats disconnects = EventStats.create((Duration)SMOOTHING_WINDOW);

        @Override
        public void onConnect(AsyncTcpSocketNio socket) {
            this.connects.recordEvent();
        }

        @Override
        public void onReadTimeout(AsyncTcpSocketNio socket) {
            this.readTimeouts.recordEvent();
        }

        @Override
        public void onRead(AsyncTcpSocketNio socket, ByteBuf buf) {
            this.reads.recordValue(buf.readRemaining());
        }

        @Override
        public void onReadEndOfStream(AsyncTcpSocketNio socket) {
            this.readEndOfStreams.recordEvent();
        }

        @Override
        public void onReadError(AsyncTcpSocketNio socket, IOException e) {
            this.readErrors.recordException((Throwable)e, (Object)socket.getRemoteAddress());
        }

        @Override
        public void onWriteTimeout(AsyncTcpSocketNio socket) {
            this.writeTimeouts.recordEvent();
        }

        @Override
        public void onWrite(AsyncTcpSocketNio socket, ByteBuf buf, int bytes) {
            this.writes.recordValue(bytes);
            if (buf.readRemaining() != bytes) {
                this.writeOverloaded.recordEvent();
            }
        }

        @Override
        public void onWriteError(AsyncTcpSocketNio socket, IOException e) {
            this.writeErrors.recordException((Throwable)e, (Object)socket.getRemoteAddress());
        }

        @Override
        public void onDisconnect(AsyncTcpSocketNio socket) {
            this.disconnects.recordEvent();
        }

        @JmxAttribute
        public EventStats getReadTimeouts() {
            return this.readTimeouts;
        }

        @JmxAttribute
        public ValueStats getReads() {
            return this.reads;
        }

        @JmxAttribute
        public EventStats getReadEndOfStreams() {
            return this.readEndOfStreams;
        }

        @JmxAttribute
        public ExceptionStats getReadErrors() {
            return this.readErrors;
        }

        @JmxAttribute
        public EventStats getWriteTimeouts() {
            return this.writeTimeouts;
        }

        @JmxAttribute
        public ValueStats getWrites() {
            return this.writes;
        }

        @JmxAttribute
        public ExceptionStats getWriteErrors() {
            return this.writeErrors;
        }

        @JmxAttribute
        public EventStats getWriteOverloaded() {
            return this.writeOverloaded;
        }

        @JmxAttribute
        public EventStats getConnects() {
            return this.connects;
        }

        @JmxAttribute
        public EventStats getDisconnects() {
            return this.disconnects;
        }

        @JmxAttribute
        public long getActiveSockets() {
            return this.connects.getTotalCount() - this.disconnects.getTotalCount();
        }
    }
}

