/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import hera.util.ValidationUtils;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtils {
    public static String buildExceptionMessage(String message, Throwable cause) {
        if (null == cause) {
            return message;
        }
        StringBuilder sb = new StringBuilder();
        if (null != message) {
            sb.append(message).append("; ");
        }
        sb.append("nested exception is ").append(cause);
        return sb.toString();
    }

    public static String trace() {
        Thread th = Thread.currentThread();
        StackTraceElement[] elements = th.getStackTrace();
        return ExceptionUtils.trace(elements, 2, elements.length);
    }

    public static String trace(StackTraceElement[] elements) {
        if (null == elements) {
            return null;
        }
        return ExceptionUtils.trace(elements, 0, elements.length);
    }

    public static String trace(StackTraceElement[] elements, int start, int end) {
        if (null == elements) {
            return null;
        }
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (elements.length < end) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ValidationUtils.assertTrue(start < end);
        StringBuilder buffer = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buffer.append(elements[i].toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String getStackTraceOf(Throwable e) {
        if (null == e) {
            return null;
        }
        StringWriter writer = new StringWriter();
        PrintWriter w = new PrintWriter(writer);
        e.printStackTrace(w);
        return writer.toString();
    }

    public static StackTraceElement[] concat(StackTraceElement[] left, StackTraceElement[] right) {
        StackTraceElement[] ret = new StackTraceElement[left.length + right.length];
        System.arraycopy(left, 0, ret, 0, left.length);
        System.arraycopy(right, 0, ret, left.length, right.length);
        return ret;
    }
}

