/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import hera.util.FilenameUtils;
import hera.util.StringUtils;
import java.io.File;
import java.util.Stack;

public class FilepathUtils {
    private static final char DIRECTORY_SEPARATOR_CHAR = '/';
    private static final String DIRECTORY_SEPARATOR = "/";
    private static final String CURRENT_DIR = ".";
    private static final String PARENT_DIR = "..";

    public static String[] getCanonicalFragments(String path) {
        String safe = path.replace(File.separatorChar, '/');
        Stack<String> stack = new Stack<String>();
        for (String fragment : safe.split(DIRECTORY_SEPARATOR)) {
            if (StringUtils.isEmpty(fragment) || CURRENT_DIR.equals(fragment)) continue;
            if (PARENT_DIR.equals(fragment)) {
                if (stack.isEmpty()) {
                    throw new IllegalArgumentException();
                }
                stack.pop();
                continue;
            }
            stack.push(fragment);
        }
        return stack.toArray(new String[stack.size()]);
    }

    public static String getCanonicalForm(String path) {
        String[] fragments = FilepathUtils.getCanonicalFragments(path);
        if (0 == fragments.length) {
            if (path.startsWith(DIRECTORY_SEPARATOR)) {
                return DIRECTORY_SEPARATOR;
            }
            return path;
        }
        StringBuilder builder = new StringBuilder();
        if (path.startsWith(DIRECTORY_SEPARATOR)) {
            builder.append(DIRECTORY_SEPARATOR);
        }
        for (int i = 0; i < fragments.length; ++i) {
            if (0 != i) {
                builder.append(DIRECTORY_SEPARATOR);
            }
            builder.append(fragments[i]);
        }
        return builder.toString();
    }

    public static String[] split(String path) {
        if (null == path) {
            return null;
        }
        String parent = FilepathUtils.getParentPath(path);
        String filename = FilepathUtils.getFilename(path);
        String name = FilenameUtils.stripExtension(filename);
        String ext = FilenameUtils.getExtension(filename);
        return new String[]{parent, name, ext};
    }

    public static String getParentPath(String path) {
        if (null == path) {
            return null;
        }
        if ("".equals(path) || DIRECTORY_SEPARATOR.equals(path)) {
            return null;
        }
        int index = path.lastIndexOf(DIRECTORY_SEPARATOR);
        if (0 == index) {
            return DIRECTORY_SEPARATOR;
        }
        if (index < 0) {
            return null;
        }
        return path.substring(0, index);
    }

    public static String getFilename(String path) {
        if (null == path) {
            return null;
        }
        String canonicalPath = FilepathUtils.getCanonicalForm(path);
        int index = canonicalPath.lastIndexOf(DIRECTORY_SEPARATOR);
        return index < 0 ? canonicalPath : canonicalPath.substring(index + 1);
    }

    public static String concat(String ... fragments) {
        return FilepathUtils.append(fragments);
    }

    public static String append(String ... fragments) {
        return FilepathUtils.append(fragments, 0, fragments.length - 1);
    }

    public static String append(String[] fragments, int start, int end) {
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        for (int i = start; i <= end; ++i) {
            int from;
            String fragment = fragments[i];
            if (null == fragment) continue;
            char[] chs = fragment.toCharArray();
            int to = chs.length;
            for (from = 0; from < to && '/' == chs[from]; ++from) {
            }
            while (from < to && '/' == chs[to - 1]) {
                --to;
            }
            if (!isFirst || 0 != from) {
                buffer.append('/');
            }
            buffer.append(chs, from, to - from);
            isFirst = false;
        }
        return buffer.toString();
    }
}

