/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import com.google.common.io.Closeables;
import hera.util.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class HexUtils {
    protected static final char CONTROL_CHARS_SHOWER = '.';
    protected static final char[] HEXA_CHARS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final char[] HEXA_CHARS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static final int N_INT_BY_BYTE = 4;
    protected static final int WIDTH_PER_LINE = 32;
    protected static final char TWO_BYTES_CHARS_SHOWER = '?';

    protected static void appendHexa(StringBuilder buffer, int ch, char[] hexChars) {
        if (ch < 16) {
            buffer.append('0');
            buffer.append(hexChars[0xF & ch]);
        } else {
            buffer.append(hexChars[0xF & ch >> 4]);
            buffer.append(hexChars[0xF & ch]);
        }
    }

    protected static void appendHexa(StringBuilder buffer, byte[] bytes, char[] hexChars) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
            int ch = 0;
            while (0 <= (ch = byteIn.read())) {
                HexUtils.appendHexa(buffer, ch, hexChars);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encode(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        HexUtils.appendHexa(buffer, bytes, HEXA_CHARS_UPPER);
        return buffer.toString();
    }

    public static String encodeLower(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        HexUtils.appendHexa(buffer, bytes, HEXA_CHARS_LOWER);
        return buffer.toString();
    }

    protected static int convert(int ch) {
        if (48 <= ch && ch <= 57) {
            return ch - 48;
        }
        if (65 <= ch && ch <= 70) {
            return 10 + ch - 65;
        }
        if (97 <= ch && ch <= 102) {
            return 10 + ch - 97;
        }
        throw new IllegalArgumentException();
    }

    public static byte[] decode(String str) {
        StringReader reader = new StringReader(str);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int ch1 = 0;
        try {
            while (0 < (ch1 = reader.read())) {
                int ch2 = reader.read();
                ValidationUtils.assertTrue(0 <= ch2);
                byteOut.write(HexUtils.convert(ch1) << 4 | HexUtils.convert(ch2));
            }
            return byteOut.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static void lineEnd(StringBuilder hexPart, StringBuilder textPart, StringBuilder ret) {
        hexPart.append("     |");
        textPart.append("|\n");
        ret.append((CharSequence)hexPart);
        ret.append((CharSequence)textPart);
        hexPart.delete(0, hexPart.capacity());
        textPart.delete(0, textPart.capacity());
    }

    public static String dump(byte[] data) {
        if (null == data) {
            return "<<null>>";
        }
        return HexUtils.dump(data, 0, data.length);
    }

    public static String dump(byte[] data, int offset, int length) {
        StringWriter writer = new StringWriter();
        HexUtils.dump(data, offset, length, writer);
        return writer.toString();
    }

    public static void dump(byte[] data, int offset, int length, Writer writer) {
        try {
            int ch;
            if (null == data) {
                writer.write("<<null>>");
                return;
            }
            if (data.length <= 0) {
                writer.write("<<EMPTY BYTES>>");
                return;
            }
            ByteArrayInputStream reader = new ByteArrayInputStream(data, offset, length);
            StringBuilder ret = new StringBuilder();
            StringBuilder hexPart = new StringBuilder();
            StringBuilder textPart = new StringBuilder();
            int address = 0;
            int cnt = 0;
            hexPart.append("          ");
            int n = 8;
            for (int i = 0; i < n; ++i) {
                hexPart.append("+-------");
                textPart.append("+---");
            }
            HexUtils.lineEnd(hexPart, textPart, ret);
            while (0 <= (ch = reader.read())) {
                if (0 == cnt) {
                    for (int i = 3; i >= 0; --i) {
                        int printByte = 0xFF & address >> 8 * i;
                        HexUtils.appendHexa(hexPart, printByte, HEXA_CHARS_UPPER);
                    }
                    hexPart.append("  ");
                    address += 32;
                }
                HexUtils.appendHexa(hexPart, ch, HEXA_CHARS_UPPER);
                if (ch < 32 || 127 <= ch) {
                    textPart.append('.');
                } else {
                    textPart.append((char)ch);
                }
                if (32 != ++cnt) continue;
                HexUtils.lineEnd(hexPart, textPart, ret);
                cnt = 0;
            }
            if (0 != cnt) {
                while (cnt < 32) {
                    hexPart.append("  ");
                    textPart.append(' ');
                    ++cnt;
                }
                HexUtils.lineEnd(hexPart, textPart, ret);
            }
            writer.write(ret.toString());
            Closeables.close((Closeable)writer, (boolean)true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

