/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import com.google.common.io.BaseEncoding;
import hera.util.StreamConsumer;
import hera.util.ValidationUtils;
import java.io.ByteArrayOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtils {
    protected static final Logger logger = LoggerFactory.getLogger(IoUtils.class);

    public static void tryFlush(Object ... flushable) {
        for (Object obj : flushable) {
            try {
                if (!(obj instanceof Flushable)) continue;
                ((Flushable)obj).flush();
            }
            catch (Throwable th) {
                logger.trace("Ignore exception: {}", th);
            }
        }
    }

    public static int stream(InputStream in, StreamConsumer consumer) throws Exception {
        int readBytes;
        ValidationUtils.assertNotNull(in);
        byte[] buffer = new byte[1024];
        int sum = 0;
        while (0 < (readBytes = in.read(buffer))) {
            consumer.apply(buffer, 0, readBytes);
            sum += readBytes;
        }
        return sum;
    }

    public static int redirect(InputStream from, final OutputStream to) throws IOException {
        ValidationUtils.assertNotNull(to);
        try {
            return IoUtils.stream(from, new StreamConsumer(){

                @Override
                public void apply(byte[] bytes, int offset, int length) throws Exception {
                    to.write(bytes, offset, length);
                }
            });
        }
        catch (Exception e) {
            throw (IOException)e;
        }
    }

    public static int redirect(Reader from, Writer to) throws IOException {
        int readBytes;
        ValidationUtils.assertNotNull(from);
        ValidationUtils.assertNotNull(to);
        char[] buffer = new char[1024];
        int sum = 0;
        while (0 < (readBytes = from.read(buffer))) {
            to.write(buffer, 0, readBytes);
            sum += readBytes;
        }
        return sum;
    }

    public static byte[] from(InputStream in) throws IOException {
        int readBytes;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] bytes = new byte[10000];
        while (0 < (readBytes = in.read(bytes))) {
            byteOut.write(bytes, 0, readBytes);
        }
        return byteOut.toByteArray();
    }

    public static String from(Reader reader) throws IOException {
        int readBytes;
        StringWriter writer = new StringWriter();
        char[] bytes = new char[10000];
        while (0 < (readBytes = reader.read(bytes))) {
            writer.write(bytes, 0, readBytes);
        }
        return writer.toString();
    }

    public static byte[] getChecksum(InputStream in) throws IOException, NoSuchAlgorithmException {
        MessageDigest checksumGenerator = MessageDigest.getInstance("MD5");
        DigestInputStream dis = new DigestInputStream(in, checksumGenerator);
        int readBytes = IoUtils.redirect(dis, new ByteArrayOutputStream());
        logger.debug("{} byte(s) read", (Object)readBytes);
        return checksumGenerator.digest();
    }

    public static String getChecksumAsString(InputStream in) throws IOException, NoSuchAlgorithmException {
        byte[] bytes = IoUtils.getChecksum(in);
        return BaseEncoding.base64().encode(bytes);
    }
}

