/*
 * Decompiled with CFR 0.152.
 */
package hera.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;

public class ObjectUtils {
    private static final SecureRandom SEEDER = new SecureRandom();
    private static String hexServerIP = null;

    protected static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (0 <= j) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    protected static String hex(int value) {
        return String.format("%08x", value);
    }

    public static String guid() {
        return ObjectUtils.guid(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String guid(Object obj) {
        StringBuilder guid = new StringBuilder(32);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        guid.append(ObjectUtils.hex(timeLow));
        if (null == hexServerIP) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                try {
                    localInetAddress = InetAddress.getByName("localhost");
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            byte[] address = localInetAddress.getAddress();
            hexServerIP = ObjectUtils.hex(ObjectUtils.getInt(address));
        }
        guid.append(hexServerIP);
        guid.append(ObjectUtils.hex(System.identityHashCode(obj)));
        int node = -1;
        SecureRandom secureRandom = SEEDER;
        synchronized (secureRandom) {
            node = SEEDER.nextInt();
        }
        guid.append(ObjectUtils.hex(node));
        return guid.toString();
    }

    public static boolean equal(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static <T> int compare(Comparable<T> o1, T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    public static <K> K nvl(K ... objs) {
        if (null == objs) {
            return null;
        }
        K ret = null;
        for (K obj : objs) {
            if (null == obj) continue;
            ret = obj;
            break;
        }
        return ret;
    }
}

