/*
 * Decompiled with CFR 0.152.
 */
package hera.util.conf;

import hera.util.Configuration;
import hera.util.ParsingUtils;
import hera.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfiguration
implements Configuration {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final boolean readOnly;

    public AbstractConfiguration() {
        this(true);
    }

    public AbstractConfiguration(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected String[] getFragments(String qualifiedName) {
        String[] splits;
        for (String split : splits = qualifiedName.split("\\.")) {
            if (!split.isEmpty()) continue;
            ValidationUtils.assertFalse(true, "Value must not empty");
        }
        return splits;
    }

    @Override
    public Configuration getSubconfiguration(String key) {
        return null;
    }

    protected abstract Object getValue(String var1);

    @Override
    public Object get(String key) {
        int dotIndex = key.indexOf(46);
        if (dotIndex < 0) {
            return this.getValue(key);
        }
        String subconfigurationName = key.substring(0, dotIndex);
        String remainder = key.substring(dotIndex + 1);
        Configuration subConfiguration = this.getSubconfiguration(subconfigurationName);
        if (null != subConfiguration) {
            return subConfiguration.get(remainder);
        }
        return null;
    }

    @Override
    public String getAsString(String key, String defaultValue) {
        Object value = this.get(key);
        if (null == value) {
            return defaultValue;
        }
        this.logger.trace("Value type: {}", value.getClass());
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        return value.toString();
    }

    @Override
    public boolean getAsBoolean(String key, boolean defaultValue) {
        String value = this.getAsString(key, null);
        return null != value ? ParsingUtils.convertToBoolean(value) : defaultValue;
    }

    @Override
    public int getAsInt(String key, int defaultValue) {
        String value = this.getAsString(key, null);
        return null != value ? ParsingUtils.convertToInt(value) : defaultValue;
    }

    @Override
    public long getAsLong(String key, long defaultValue) {
        String value = this.getAsString(key, null);
        return null != value ? ParsingUtils.convertToLong(value) : defaultValue;
    }

    @Override
    public double getAsDouble(String key, double defaultValue) {
        String value = this.getAsString(key, null);
        return null != value ? ParsingUtils.convertToDouble(value) : defaultValue;
    }

    @Override
    public List<String> getAsList(String key) {
        return this.parse(this.getAsString(key, null));
    }

    protected List<String> parse(String value) {
        String[] splits;
        if (null == value) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String split : splits = value.split("[,|\\r|\\n]")) {
            String target = split.trim();
            if (null == target || target.isEmpty()) continue;
            list.add(target);
        }
        return list;
    }

    protected void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Configuration is read-only");
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

