/*
 * Decompiled with CFR 0.152.
 */
package hera.util.conf;

import hera.util.Configuration;
import hera.util.conf.AbstractConfiguration;
import hera.util.conf.DummyConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InMemoryConfiguration
extends AbstractConfiguration {
    protected Map<String, Configuration> subconfigurations = new HashMap<String, Configuration>();
    protected Map<String, Object> key2value = new HashMap<String, Object>();

    public InMemoryConfiguration() {
        this(false);
    }

    public InMemoryConfiguration(boolean readOnly) {
        this(readOnly, DummyConfiguration.getInstance());
    }

    public InMemoryConfiguration(Configuration configuration) {
        this(false, configuration);
    }

    public InMemoryConfiguration(boolean readOnly, Configuration configuration) {
        this(readOnly, configuration.asMap());
    }

    public InMemoryConfiguration(boolean readOnly, Map<String, Object> map) {
        super(readOnly);
        this.key2value.putAll(map);
        if (readOnly) {
            this.key2value = Collections.unmodifiableMap(this.key2value);
            this.subconfigurations = Collections.unmodifiableMap(this.subconfigurations);
        }
    }

    @Override
    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.key2value);
    }

    @Override
    public void define(String key, Object value) {
        this.checkReadOnly();
        this.logger.debug("{}: {}", (Object)key, value);
        int dotIndex = key.indexOf(46);
        if (dotIndex < 0) {
            this.key2value.put(key, value);
        } else {
            String subconfigurationName = key.substring(0, dotIndex);
            String remainder = key.substring(dotIndex + 1);
            Configuration subconfiguration = this.subconfigurations.get(subconfigurationName);
            if (null == subconfiguration) {
                InMemoryConfiguration newSubconfiguration = new InMemoryConfiguration();
                newSubconfiguration.define(remainder, value);
                this.subconfigurations.put(subconfigurationName, newSubconfiguration);
            } else {
                subconfiguration.define(remainder, value);
            }
        }
    }

    @Override
    public Configuration getSubconfiguration(String key) {
        this.logger.trace("Key: {}", (Object)key);
        Configuration subconfiguration = this.subconfigurations.get(key);
        if (null == subconfiguration) {
            this.logger.info("The subconfiguration for {} is null", (Object)key);
            this.logger.debug("Subconfigurations: {}", this.subconfigurations);
        }
        return subconfiguration;
    }

    @Override
    protected Object getValue(String key) {
        this.logger.trace("Key: {}", (Object)key);
        return this.key2value.get(key);
    }

    @Override
    public void remove(String key) {
        this.checkReadOnly();
        this.key2value.remove(key);
    }

    public String toString() {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(this.subconfigurations);
        merged.putAll(this.key2value);
        return ((Object)merged).toString();
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof InMemoryConfiguration)) {
            return false;
        }
        InMemoryConfiguration other = (InMemoryConfiguration)obj;
        return this.isReadOnly() == other.isReadOnly() && this.key2value.equals(other.key2value) && this.subconfigurations.equals(other.subconfigurations);
    }
}

