/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ActivePublications;
import io.aeron.ActiveSubscriptions;
import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.DriverEventsAdapter;
import io.aeron.DriverEventsListener;
import io.aeron.DriverProxy;
import io.aeron.ErrorCode;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.LogBuffersFactory;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import io.aeron.exceptions.RegistrationException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.agrona.ErrorHandler;
import org.agrona.ManagedResource;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.UnsafeBufferPosition;

class ClientConductor
implements Agent,
DriverEventsListener {
    private static final long NO_CORRELATION_ID = -1L;
    private static final long RESOURCE_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(1L);
    private static final long RESOURCE_LINGER_NS = TimeUnit.SECONDS.toNanos(3L);
    private final long keepAliveIntervalNs;
    private final long driverTimeoutMs;
    private final long driverTimeoutNs;
    private final long interServiceTimeoutNs;
    private final long publicationConnectionTimeoutMs;
    private long timeOfLastKeepAliveNs;
    private long timeOfLastResourcesCheckNs;
    private long timeOfLastServiceNs;
    private volatile boolean isClosed;
    private final Lock clientLock;
    private final EpochClock epochClock;
    private final FileChannel.MapMode imageMapMode;
    private final NanoClock nanoClock;
    private final DriverEventsAdapter driverEventsAdapter;
    private final LogBuffersFactory logBuffersFactory;
    private final ActivePublications activePublications = new ActivePublications();
    private final Long2ObjectHashMap<ExclusivePublication> activeExclusivePublications = new Long2ObjectHashMap();
    private final ActiveSubscriptions activeSubscriptions = new ActiveSubscriptions();
    private final ArrayList<ManagedResource> lingeringResources = new ArrayList();
    private final UnavailableImageHandler defaultUnavailableImageHandler;
    private final AvailableImageHandler defaultAvailableImageHandler;
    private final UnsafeBuffer counterValuesBuffer;
    private final DriverProxy driverProxy;
    private final ErrorHandler errorHandler;
    private final AgentInvoker driverAgentInvoker;
    private RegistrationException driverException;

    ClientConductor(Aeron.Context ctx) {
        long nowNs;
        this.clientLock = ctx.clientLock();
        this.epochClock = ctx.epochClock();
        this.nanoClock = ctx.nanoClock();
        this.errorHandler = ctx.errorHandler();
        this.counterValuesBuffer = ctx.countersValuesBuffer();
        this.driverProxy = ctx.driverProxy();
        this.logBuffersFactory = ctx.logBuffersFactory();
        this.imageMapMode = ctx.imageMapMode();
        this.keepAliveIntervalNs = ctx.keepAliveInterval();
        this.driverTimeoutMs = ctx.driverTimeoutMs();
        this.driverTimeoutNs = TimeUnit.MILLISECONDS.toNanos(this.driverTimeoutMs);
        this.interServiceTimeoutNs = ctx.interServiceTimeout();
        this.publicationConnectionTimeoutMs = ctx.publicationConnectionTimeout();
        this.defaultAvailableImageHandler = ctx.availableImageHandler();
        this.defaultUnavailableImageHandler = ctx.unavailableImageHandler();
        this.driverEventsAdapter = new DriverEventsAdapter(ctx.toClientBuffer(), this);
        this.driverAgentInvoker = ctx.driverAgentInvoker();
        this.timeOfLastKeepAliveNs = nowNs = this.nanoClock.nanoTime();
        this.timeOfLastResourcesCheckNs = nowNs;
        this.timeOfLastServiceNs = nowNs;
    }

    @Override
    public void onClose() {
        if (!this.isClosed) {
            this.isClosed = true;
            int lingeringResourcesSize = this.lingeringResources.size();
            this.forceClosePublicationsAndSubscriptions();
            if (this.lingeringResources.size() > lingeringResourcesSize) {
                Aeron.sleep(1L);
            }
            int size = this.lingeringResources.size();
            for (int i = 0; i < size; ++i) {
                this.lingeringResources.get(i).delete();
            }
            this.lingeringResources.clear();
        }
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (this.clientLock.tryLock()) {
            try {
                if (this.isClosed) {
                    throw new AgentTerminationException();
                }
                workCount = this.service(-1L, null);
            }
            finally {
                this.clientLock.unlock();
            }
        }
        return workCount;
    }

    @Override
    public String roleName() {
        return "aeron-client-conductor";
    }

    boolean isClosed() {
        return this.isClosed;
    }

    Lock clientLock() {
        return this.clientLock;
    }

    void handleError(Throwable ex) {
        this.errorHandler.onError(ex);
    }

    Publication addPublication(String channel, int streamId) {
        if (this.isClosed) {
            throw new IllegalStateException("Aeron client is closed");
        }
        Publication publication = this.activePublications.get(channel, streamId);
        if (null == publication) {
            this.awaitResponse(this.driverProxy.addPublication(channel, streamId), channel);
            publication = this.activePublications.get(channel, streamId);
        }
        publication.incRef();
        return publication;
    }

    ExclusivePublication addExclusivePublication(String channel, int streamId) {
        if (this.isClosed) {
            throw new IllegalStateException("Aeron client is closed");
        }
        long registrationId = this.driverProxy.addExclusivePublication(channel, streamId);
        this.awaitResponse(registrationId, channel);
        return this.activeExclusivePublications.get(registrationId);
    }

    void releasePublication(Publication publication) {
        if (this.isClosed) {
            throw new IllegalStateException("Aeron client is closed");
        }
        if (publication == this.activePublications.remove(publication.channel(), publication.streamId())) {
            this.lingerResource(publication.managedResource());
            this.awaitResponse(this.driverProxy.removePublication(publication.registrationId()), null);
        }
    }

    void releasePublication(ExclusivePublication publication) {
        if (this.isClosed) {
            throw new IllegalStateException("Aeron client is closed");
        }
        if (publication == this.activeExclusivePublications.remove(publication.registrationId())) {
            this.lingerResource(publication.managedResource());
            this.awaitResponse(this.driverProxy.removePublication(publication.registrationId()), null);
        }
    }

    void asyncReleasePublication(long registrationId) {
        this.driverProxy.removePublication(registrationId);
    }

    Subscription addSubscription(String channel, int streamId) {
        return this.addSubscription(channel, streamId, this.defaultAvailableImageHandler, this.defaultUnavailableImageHandler);
    }

    Subscription addSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        if (this.isClosed) {
            throw new IllegalStateException("Aeron client is closed");
        }
        long correlationId = this.driverProxy.addSubscription(channel, streamId);
        Subscription subscription = new Subscription(this, channel, streamId, correlationId, availableImageHandler, unavailableImageHandler);
        this.activeSubscriptions.add(subscription);
        this.awaitResponse(correlationId, channel);
        return subscription;
    }

    void releaseSubscription(Subscription subscription) {
        if (this.isClosed) {
            throw new IllegalStateException("Aeron client is closed");
        }
        this.awaitResponse(this.driverProxy.removeSubscription(subscription.registrationId()), null);
        this.activeSubscriptions.remove(subscription);
    }

    void asyncReleaseSubscription(Subscription subscription) {
        this.driverProxy.removeSubscription(subscription.registrationId());
    }

    void addDestination(long registrationId, String endpointChannel) {
        if (this.isClosed) {
            throw new IllegalStateException("Aeron client is closed");
        }
        this.awaitResponse(this.driverProxy.addDestination(registrationId, endpointChannel), null);
    }

    void removeDestination(long registrationId, String endpointChannel) {
        if (this.isClosed) {
            throw new IllegalStateException("Aeron client is closed");
        }
        this.awaitResponse(this.driverProxy.removeDestination(registrationId, endpointChannel), null);
    }

    @Override
    public void onError(long correlationId, ErrorCode errorCode, String message) {
        this.driverException = new RegistrationException(errorCode, message);
    }

    @Override
    public void onNewPublication(long correlationId, long registrationId, int streamId, int sessionId, int publicationLimitId, String channel, String logFileName) {
        Publication publication = new Publication(this, channel, streamId, sessionId, new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), this.logBuffersFactory.map(logFileName, FileChannel.MapMode.READ_WRITE), registrationId, correlationId);
        this.activePublications.put(channel, streamId, publication);
    }

    @Override
    public void onNewExclusivePublication(long correlationId, long registrationId, int streamId, int sessionId, int publicationLimitId, String channel, String logFileName) {
        ExclusivePublication publication = new ExclusivePublication(this, channel, streamId, sessionId, new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), this.logBuffersFactory.map(logFileName, FileChannel.MapMode.READ_WRITE), registrationId, correlationId);
        this.activeExclusivePublications.put(correlationId, publication);
    }

    @Override
    public void onAvailableImage(long correlationId, int streamId, int sessionId, long subscriberRegistrationId, int subscriberPositionId, String logFileName, String sourceIdentity) {
        this.activeSubscriptions.forEach(streamId, subscription -> {
            if (subscription.registrationId() == subscriberRegistrationId && !subscription.hasImage(correlationId)) {
                Image image = new Image((Subscription)subscription, sessionId, new UnsafeBufferPosition(this.counterValuesBuffer, subscriberPositionId), this.logBuffersFactory.map(logFileName, this.imageMapMode), this.errorHandler, sourceIdentity, correlationId);
                try {
                    AvailableImageHandler handler = subscription.availableImageHandler();
                    if (null != handler) {
                        handler.onAvailableImage(image);
                    }
                }
                catch (Throwable ex) {
                    this.errorHandler.onError(ex);
                }
                subscription.addImage(image);
            }
        });
    }

    @Override
    public void onUnavailableImage(long correlationId, int streamId) {
        this.activeSubscriptions.forEach(streamId, subscription -> {
            Image image = subscription.removeImage(correlationId);
            if (null != image) {
                try {
                    UnavailableImageHandler handler = subscription.unavailableImageHandler();
                    if (null != handler) {
                        handler.onUnavailableImage(image);
                    }
                }
                catch (Throwable ex) {
                    this.errorHandler.onError(ex);
                }
            }
        });
    }

    DriverEventsAdapter driverListenerAdapter() {
        return this.driverEventsAdapter;
    }

    void lingerResource(ManagedResource managedResource) {
        managedResource.timeOfLastStateChange(this.nanoClock.nanoTime());
        this.lingeringResources.add(managedResource);
    }

    boolean isPublicationConnected(long timeOfLastStatusMessageMs) {
        return this.epochClock.time() <= timeOfLastStatusMessageMs + this.publicationConnectionTimeoutMs;
    }

    private int service(long correlationId, String expectedChannel) {
        int workCount;
        block2: {
            workCount = 0;
            try {
                workCount += this.onCheckTimeouts();
                workCount += this.driverEventsAdapter.receive(correlationId, expectedChannel);
            }
            catch (Throwable throwable) {
                this.errorHandler.onError(throwable);
                if (!ClientConductor.isClientApiCall(correlationId)) break block2;
                throw throwable;
            }
        }
        return workCount;
    }

    private static boolean isClientApiCall(long correlationId) {
        return correlationId != -1L;
    }

    private void awaitResponse(long correlationId, String expectedChannel) {
        this.driverException = null;
        long deadlineNs = this.nanoClock.nanoTime() + this.driverTimeoutNs;
        do {
            if (null == this.driverAgentInvoker) {
                Aeron.sleep(1L);
            } else {
                this.driverAgentInvoker.invoke();
            }
            this.service(correlationId, expectedChannel);
            if (this.driverEventsAdapter.lastReceivedCorrelationId() != correlationId) continue;
            if (null != this.driverException) {
                throw this.driverException;
            }
            return;
        } while (this.nanoClock.nanoTime() < deadlineNs);
        throw new DriverTimeoutException("No response from MediaDriver within (ns):" + this.driverTimeoutNs);
    }

    private int onCheckTimeouts() {
        int workCount = 0;
        long nowNs = this.nanoClock.nanoTime();
        if (nowNs > this.timeOfLastServiceNs + Aeron.IDLE_SLEEP_NS) {
            this.checkServiceInterval(nowNs);
            this.timeOfLastServiceNs = nowNs;
            workCount += this.checkLiveness(nowNs);
            workCount += this.checkLingeringResources(nowNs);
        }
        return workCount;
    }

    private void checkServiceInterval(long nowNs) {
        if (nowNs > this.timeOfLastServiceNs + this.interServiceTimeoutNs) {
            int lingeringResourcesSize = this.lingeringResources.size();
            this.forceClosePublicationsAndSubscriptions();
            if (this.lingeringResources.size() > lingeringResourcesSize) {
                Aeron.sleep(1000L);
            }
            this.onClose();
            throw new ConductorServiceTimeoutException("Exceeded (ns): " + this.interServiceTimeoutNs);
        }
    }

    private int checkLiveness(long nowNs) {
        if (nowNs > this.timeOfLastKeepAliveNs + this.keepAliveIntervalNs) {
            if (this.epochClock.time() > this.driverProxy.timeOfLastDriverKeepaliveMs() + this.driverTimeoutMs) {
                this.onClose();
                throw new DriverTimeoutException("MediaDriver keepalive older than (ms): " + this.driverTimeoutMs);
            }
            this.driverProxy.sendClientKeepalive();
            this.timeOfLastKeepAliveNs = nowNs;
            return 1;
        }
        return 0;
    }

    private int checkLingeringResources(long nowNs) {
        if (nowNs > this.timeOfLastResourcesCheckNs + RESOURCE_TIMEOUT_NS) {
            int lastIndex;
            ArrayList<ManagedResource> lingeringResources = this.lingeringResources;
            for (int i = lastIndex = lingeringResources.size() - 1; i >= 0; --i) {
                ManagedResource resource = lingeringResources.get(i);
                if (nowNs <= resource.timeOfLastStateChange() + RESOURCE_LINGER_NS) continue;
                ArrayListUtil.fastUnorderedRemove(lingeringResources, i, lastIndex);
                --lastIndex;
                resource.delete();
            }
            this.timeOfLastResourcesCheckNs = nowNs;
            return 1;
        }
        return 0;
    }

    private void forceClosePublicationsAndSubscriptions() {
        for (ExclusivePublication publication : this.activeExclusivePublications.values()) {
            publication.forceClose();
        }
        this.activeExclusivePublications.clear();
        this.activePublications.close();
        this.activeSubscriptions.close();
    }
}

