/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.LogBuffers;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.HeaderWriter;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermAppender;
import org.agrona.DirectBuffer;
import org.agrona.ManagedResource;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public class Publication
implements AutoCloseable {
    public static final long NOT_CONNECTED = -1L;
    public static final long BACK_PRESSURED = -2L;
    public static final long ADMIN_ACTION = -3L;
    public static final long CLOSED = -4L;
    public static final long MAX_POSITION_EXCEEDED = -5L;
    private final long originalRegistrationId;
    private final long registrationId;
    private final long maxPossiblePosition;
    private int refCount = 0;
    private final int streamId;
    private final int sessionId;
    private final int initialTermId;
    private final int maxMessageLength;
    private final int maxPayloadLength;
    private final int positionBitsToShift;
    private volatile boolean isClosed = false;
    private final TermAppender[] termAppenders = new TermAppender[3];
    private final ReadablePosition positionLimit;
    private final UnsafeBuffer logMetaDataBuffer;
    private final HeaderWriter headerWriter;
    private final LogBuffers logBuffers;
    private final ClientConductor conductor;
    private final String channel;

    Publication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, LogBuffers logBuffers, long originalRegistrationId, long registrationId) {
        UnsafeBuffer[] buffers = logBuffers.termBuffers();
        UnsafeBuffer logMetaDataBuffer = logBuffers.metaDataBuffer();
        for (int i = 0; i < 3; ++i) {
            this.termAppenders[i] = new TermAppender(buffers[i], logMetaDataBuffer, i);
        }
        int termLength = logBuffers.termLength();
        this.maxPayloadLength = LogBufferDescriptor.mtuLength(logMetaDataBuffer) - 32;
        this.maxMessageLength = FrameDescriptor.computeMaxMessageLength(termLength);
        this.maxPossiblePosition = (long)termLength * 0x80000000L;
        this.conductor = clientConductor;
        this.channel = channel;
        this.streamId = streamId;
        this.sessionId = sessionId;
        this.initialTermId = LogBufferDescriptor.initialTermId(logMetaDataBuffer);
        this.logMetaDataBuffer = logMetaDataBuffer;
        this.originalRegistrationId = originalRegistrationId;
        this.registrationId = registrationId;
        this.positionLimit = positionLimit;
        this.logBuffers = logBuffers;
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        this.headerWriter = new HeaderWriter(LogBufferDescriptor.defaultFrameHeader(logMetaDataBuffer));
    }

    public int termBufferLength() {
        return this.logBuffers.termLength();
    }

    public long maxPossiblePosition() {
        return this.maxPossiblePosition;
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public int maxMessageLength() {
        return this.maxMessageLength;
    }

    public int maxPayloadLength() {
        return this.maxPayloadLength;
    }

    public long originalRegistrationId() {
        return this.originalRegistrationId;
    }

    public boolean isOriginal() {
        return this.originalRegistrationId == this.registrationId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public boolean isConnected() {
        return !this.isClosed && this.conductor.isPublicationConnected(LogBufferDescriptor.timeOfLastStatusMessage(this.logMetaDataBuffer));
    }

    @Override
    public void close() {
        this.conductor.clientLock().lock();
        try {
            if (!this.isClosed && --this.refCount == 0) {
                this.isClosed = true;
                this.conductor.releasePublication(this);
            }
        }
        finally {
            this.conductor.clientLock().unlock();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void forceClose() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.conductor.asyncReleasePublication(this.registrationId);
            this.conductor.lingerResource(this.managedResource());
        }
    }

    public long position() {
        if (this.isClosed) {
            return -4L;
        }
        long rawTail = LogBufferDescriptor.rawTailVolatile(this.logMetaDataBuffer);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, this.logBuffers.termLength());
        return LogBufferDescriptor.computePosition(LogBufferDescriptor.termId(rawTail), termOffset, this.positionBitsToShift, this.initialTermId);
    }

    public long positionLimit() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile();
    }

    public long offer(DirectBuffer buffer) {
        return this.offer(buffer, 0, buffer.capacity());
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.offer(buffer, offset, length, null);
    }

    public long offer(DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int partitionIndex = LogBufferDescriptor.activePartitionIndex(this.logMetaDataBuffer);
            TermAppender termAppender = this.termAppenders[partitionIndex];
            long rawTail = termAppender.rawTailVolatile();
            long termOffset = rawTail & 0xFFFFFFFFL;
            long position = LogBufferDescriptor.computeTermBeginPosition(LogBufferDescriptor.termId(rawTail), this.positionBitsToShift, this.initialTermId) + termOffset;
            if (position < limit) {
                long result;
                if (length <= this.maxPayloadLength) {
                    result = termAppender.appendUnfragmentedMessage(this.headerWriter, buffer, offset, length, reservedValueSupplier);
                } else {
                    this.checkForMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.headerWriter, buffer, offset, length, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(partitionIndex, (int)termOffset, position, result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public long tryClaim(int length, BufferClaim bufferClaim) {
        this.checkForMaxPayloadLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int partitionIndex = LogBufferDescriptor.activePartitionIndex(this.logMetaDataBuffer);
            TermAppender termAppender = this.termAppenders[partitionIndex];
            long rawTail = termAppender.rawTailVolatile();
            long termOffset = rawTail & 0xFFFFFFFFL;
            long position = LogBufferDescriptor.computeTermBeginPosition(LogBufferDescriptor.termId(rawTail), this.positionBitsToShift, this.initialTermId) + termOffset;
            if (position < limit) {
                long result = termAppender.claim(this.headerWriter, length, bufferClaim);
                newPosition = this.newPosition(partitionIndex, (int)termOffset, position, result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public void addDestination(String endpointChannel) {
        this.conductor.clientLock().lock();
        try {
            this.conductor.addDestination(this.registrationId, endpointChannel);
        }
        finally {
            this.conductor.clientLock().unlock();
        }
    }

    public void removeDestination(String endpointChannel) {
        this.conductor.clientLock().lock();
        try {
            this.conductor.removeDestination(this.registrationId, endpointChannel);
        }
        finally {
            this.conductor.clientLock().unlock();
        }
    }

    void incRef() {
        ++this.refCount;
    }

    private long newPosition(int index, int currentTail, long position, long result) {
        long newPosition = -3L;
        int termOffset = LogBufferDescriptor.termOffset(result);
        if (termOffset > 0) {
            newPosition = position - (long)currentTail + (long)termOffset;
        } else if (position + (long)currentTail > this.maxPossiblePosition) {
            newPosition = -5L;
        } else if (termOffset == -1) {
            int nextIndex = LogBufferDescriptor.nextPartitionIndex(index);
            LogBufferDescriptor.initialiseTailWithTermId(this.logMetaDataBuffer, nextIndex, LogBufferDescriptor.termId(result) + 1);
            LogBufferDescriptor.activePartitionIndexOrdered(this.logMetaDataBuffer, nextIndex);
        }
        return newPosition;
    }

    private long backPressureStatus(long currentPosition, int messageLength) {
        long status = -1L;
        if (currentPosition + (long)messageLength >= this.maxPossiblePosition) {
            status = -5L;
        } else if (this.conductor.isPublicationConnected(LogBufferDescriptor.timeOfLastStatusMessage(this.logMetaDataBuffer))) {
            status = -2L;
        }
        return status;
    }

    private void checkForMaxPayloadLength(int length) {
        if (length > this.maxPayloadLength) {
            throw new IllegalArgumentException("Claim exceeds maxPayloadLength of " + this.maxPayloadLength + ", length=" + length);
        }
    }

    private void checkForMaxMessageLength(int length) {
        if (length > this.maxMessageLength) {
            throw new IllegalArgumentException("Message exceeds maxMessageLength of " + this.maxMessageLength + ", length=" + length);
        }
    }

    ManagedResource managedResource() {
        return new PublicationManagedResource();
    }

    private class PublicationManagedResource
    implements ManagedResource {
        private long timeOfLastStateChange = 0L;

        private PublicationManagedResource() {
        }

        @Override
        public void timeOfLastStateChange(long time) {
            this.timeOfLastStateChange = time;
        }

        @Override
        public long timeOfLastStateChange() {
            return this.timeOfLastStateChange;
        }

        @Override
        public void delete() {
            Publication.this.logBuffers.close();
        }
    }
}

