/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.driver.Configuration;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import org.agrona.concurrent.ShutdownSignalBarrier;

public final class ArchivingMediaDriver
implements AutoCloseable {
    private final MediaDriver driver;
    private final Archive archive;

    private ArchivingMediaDriver(MediaDriver driver, Archive archive) {
        this.driver = driver;
        this.archive = archive;
    }

    public Archive archive() {
        return this.archive;
    }

    public MediaDriver mediaDriver() {
        return this.driver;
    }

    @Override
    public void close() {
        this.archive.close();
        this.driver.close();
    }

    public static void main(String[] args) {
        MediaDriver.loadPropertiesFiles(args);
        try (ArchivingMediaDriver ignore = ArchivingMediaDriver.launch();){
            new ShutdownSignalBarrier().await();
            System.out.println("Shutdown Archive...");
        }
    }

    public static ArchivingMediaDriver launch() {
        return ArchivingMediaDriver.launch(new MediaDriver.Context(), new Archive.Context());
    }

    public static ArchivingMediaDriver launch(MediaDriver.Context driverCtx, Archive.Context archiveCtx) {
        boolean useConcurrentCounterManager = driverCtx.threadingMode() != ThreadingMode.INVOKER || driverCtx.threadingMode() == null && Configuration.THREADING_MODE_DEFAULT != ThreadingMode.INVOKER;
        MediaDriver driver = MediaDriver.launch(driverCtx.useConcurrentCounterManager(useConcurrentCounterManager));
        Archive archive = Archive.launch(archiveCtx.mediaDriverAgentInvoker(driver.sharedAgentInvoker()).countersManager(driver.context().countersManager()).errorHandler(driver.context().errorHandler()));
        return new ArchivingMediaDriver(driver, archive);
    }
}

