/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.ControlRequestListener;
import io.aeron.archive.codecs.CloseSessionRequestDecoder;
import io.aeron.archive.codecs.ConnectRequestDecoder;
import io.aeron.archive.codecs.ListRecordingsForUriRequestDecoder;
import io.aeron.archive.codecs.ListRecordingsRequestDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.ReplayRequestDecoder;
import io.aeron.archive.codecs.StartRecordingRequestDecoder;
import io.aeron.archive.codecs.StopRecordingRequestDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

class ControlRequestAdapter
implements FragmentHandler {
    private final ControlRequestListener listener;
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ConnectRequestDecoder connectRequestDecoder = new ConnectRequestDecoder();
    private final CloseSessionRequestDecoder closeSessionRequestDecoder = new CloseSessionRequestDecoder();
    private final StartRecordingRequestDecoder startRecordingRequestDecoder = new StartRecordingRequestDecoder();
    private final StopRecordingRequestDecoder stopRecordingRequestDecoder = new StopRecordingRequestDecoder();
    private final ReplayRequestDecoder replayRequestDecoder = new ReplayRequestDecoder();
    private final ListRecordingsRequestDecoder listRecordingsRequestDecoder = new ListRecordingsRequestDecoder();
    private final ListRecordingsForUriRequestDecoder listRecordingsForUriRequestDecoder = new ListRecordingsForUriRequestDecoder();

    ControlRequestAdapter(ControlRequestListener listener) {
        this.listener = listener;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.headerDecoder.wrap(buffer, offset);
        int templateId = this.headerDecoder.templateId();
        switch (templateId) {
            case 2: {
                this.connectRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onConnect(this.connectRequestDecoder.correlationId(), this.connectRequestDecoder.responseChannel(), this.connectRequestDecoder.responseStreamId());
                break;
            }
            case 3: {
                this.closeSessionRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onCloseSession(this.closeSessionRequestDecoder.controlSessionId());
                break;
            }
            case 4: {
                this.startRecordingRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onStartRecording(this.startRecordingRequestDecoder.controlSessionId(), this.startRecordingRequestDecoder.correlationId(), this.startRecordingRequestDecoder.streamId(), this.startRecordingRequestDecoder.channel(), this.startRecordingRequestDecoder.sourceLocation());
                break;
            }
            case 5: {
                this.stopRecordingRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onStopRecording(this.stopRecordingRequestDecoder.controlSessionId(), this.stopRecordingRequestDecoder.correlationId(), this.stopRecordingRequestDecoder.streamId(), this.stopRecordingRequestDecoder.channel());
                break;
            }
            case 6: {
                this.replayRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onStartReplay(this.replayRequestDecoder.controlSessionId(), this.replayRequestDecoder.correlationId(), this.replayRequestDecoder.recordingId(), this.replayRequestDecoder.position(), this.replayRequestDecoder.length(), this.replayRequestDecoder.replayStreamId(), this.replayRequestDecoder.replayChannel());
                break;
            }
            case 7: {
                this.listRecordingsRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onListRecordings(this.listRecordingsRequestDecoder.controlSessionId(), this.listRecordingsRequestDecoder.correlationId(), this.listRecordingsRequestDecoder.fromRecordingId(), this.listRecordingsRequestDecoder.recordCount());
                break;
            }
            case 8: {
                this.listRecordingsForUriRequestDecoder.wrap(buffer, offset + 8, this.headerDecoder.blockLength(), this.headerDecoder.version());
                this.listener.onListRecordingsForUri(this.listRecordingsForUriRequestDecoder.controlSessionId(), this.listRecordingsForUriRequestDecoder.correlationId(), this.listRecordingsForUriRequestDecoder.fromRecordingId(), this.listRecordingsForUriRequestDecoder.recordCount(), this.listRecordingsForUriRequestDecoder.streamId(), this.listRecordingsForUriRequestDecoder.channel());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected template id:" + templateId);
            }
        }
    }
}

