/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Publication;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseEncoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.Strings;
import org.agrona.concurrent.UnsafeBuffer;

class ControlResponseProxy {
    private static final int HEADER_LENGTH = 8;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final ExpandableDirectByteBuffer buffer = new ExpandableDirectByteBuffer(2048);
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ControlResponseEncoder responseEncoder = new ControlResponseEncoder();
    private final RecordingDescriptorEncoder recordingDescriptorEncoder = new RecordingDescriptorEncoder();

    ControlResponseProxy() {
    }

    int sendDescriptor(long controlSessionId, long correlationId, UnsafeBuffer descriptorBuffer, Publication controlPublication) {
        int offset = 24;
        int length = descriptorBuffer.getInt(0) + 8;
        this.recordingDescriptorEncoder.wrapAndApplyHeader(descriptorBuffer, 24, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId);
        return this.send(controlPublication, descriptorBuffer, 24, length) ? length : 0;
    }

    boolean sendResponse(long controlSessionId, long correlationId, long relevantId, ControlResponseCode code, String errorMessage, Publication controlPublication) {
        this.responseEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).relevantId(relevantId).code(code);
        if (!Strings.isEmpty(errorMessage)) {
            this.responseEncoder.errorMessage(errorMessage);
        } else {
            this.responseEncoder.putErrorMessage(EMPTY_BYTE_ARRAY, 0, 0);
        }
        return this.send(controlPublication, this.buffer, 0, 8 + this.responseEncoder.encodedLength());
    }

    private boolean send(Publication controlPublication, DirectBuffer buffer, int offset, int length) {
        for (int i = 0; i < 3; ++i) {
            long result = controlPublication.offer(buffer, offset, length);
            if (result > 0L) {
                return true;
            }
            if (result != -1L && result != -4L) continue;
            throw new IllegalStateException("Response channel is down: " + controlPublication);
        }
        return false;
    }
}

