/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Publication;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.RecordingProgressEncoder;
import io.aeron.archive.codecs.RecordingStartedEncoder;
import io.aeron.archive.codecs.RecordingStoppedEncoder;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.concurrent.IdleStrategy;

class RecordingEventsProxy {
    private final IdleStrategy idleStrategy;
    private final Publication recordingEventsPublication;
    private final ExpandableDirectByteBuffer outboundBuffer = new ExpandableDirectByteBuffer(512);
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final RecordingStartedEncoder recordingStartedEncoder = new RecordingStartedEncoder();
    private final RecordingProgressEncoder recordingProgressEncoder = new RecordingProgressEncoder();
    private final RecordingStoppedEncoder recordingStoppedEncoder = new RecordingStoppedEncoder();

    RecordingEventsProxy(IdleStrategy idleStrategy, Publication recordingEventsPublication) {
        this.idleStrategy = idleStrategy;
        this.recordingEventsPublication = recordingEventsPublication;
    }

    void started(long recordingId, long startPosition, int sessionId, int streamId, String channel, String sourceIdentity) {
        this.recordingStartedEncoder.wrapAndApplyHeader(this.outboundBuffer, 0, this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).sessionId(sessionId).streamId(streamId).channel(channel).sourceIdentity(sourceIdentity);
        this.send(this.recordingStartedEncoder.encodedLength());
    }

    void progress(long recordingId, long startPosition, long position) {
        this.recordingProgressEncoder.wrapAndApplyHeader(this.outboundBuffer, 0, this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).position(position);
        this.send(this.recordingProgressEncoder.encodedLength());
    }

    void stopped(long recordingId, long startPosition, long stopPosition) {
        this.recordingStoppedEncoder.wrapAndApplyHeader(this.outboundBuffer, 0, this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).stopPosition(stopPosition);
        this.send(this.recordingStoppedEncoder.encodedLength());
    }

    private void send(int length) {
        int fullLength = 8 + length;
        while (true) {
            long result;
            if ((result = this.recordingEventsPublication.offer(this.outboundBuffer, 0, fullLength)) > 0L || result == -1L) break;
            if (result == -4L || result == -5L) {
                throw new IllegalStateException();
            }
            this.idleStrategy.idle();
        }
        this.idleStrategy.reset();
    }
}

