/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.SimplifiedControlledFragmentHandler;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.agrona.BitUtil;
import org.agrona.IoUtil;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

class RecordingFragmentReader
implements AutoCloseable {
    static final long NULL_POSITION = -1L;
    static final long NULL_LENGTH = -1L;
    private final File archiveDir;
    private final long recordingId;
    private final long startPosition;
    private final int segmentLength;
    private final int termLength;
    private final RecordingDescriptorDecoder descriptorDecoder;
    private final AtomicCounter recordingPosition;
    private final UnsafeBuffer termBuffer;
    private MappedByteBuffer mappedSegmentBuffer;
    private long fromPosition;
    private long stopPosition;
    private long replayPosition;
    private long replayLimit;
    private int termOffset;
    private int termStartSegmentOffset;
    private int segmentFileIndex;
    private boolean isDone = false;

    RecordingFragmentReader(RecordingDescriptorDecoder descriptorDecoder, File archiveDir, long position, long length, AtomicCounter recordingPosition) throws IOException {
        long replayLength;
        this.descriptorDecoder = descriptorDecoder;
        this.stopPosition = descriptorDecoder.stopPosition();
        this.termLength = descriptorDecoder.termBufferLength();
        this.segmentLength = descriptorDecoder.segmentFileLength();
        this.startPosition = descriptorDecoder.startPosition();
        this.recordingId = descriptorDecoder.recordingId();
        if (this.stopPosition == -1L) {
            if (recordingPosition == null) {
                throw new IllegalArgumentException("Recording descriptor indicates live recording, but recordedPosition is null. Replay for recording id:" + this.recordingId);
            }
            if (recordingPosition.isClosed()) {
                throw new IllegalStateException("Position closed concurrently to replay construction. Replay for recording id:" + this.recordingId);
            }
            this.stopPosition = recordingPosition.get();
        }
        this.archiveDir = archiveDir;
        long l = this.fromPosition = position == -1L ? this.startPosition : position;
        if (this.fromPosition < 0L) {
            throw new IllegalArgumentException("fromPosition must be positive");
        }
        this.recordingPosition = recordingPosition;
        long maxLength = recordingPosition == null ? this.stopPosition - this.fromPosition : Long.MAX_VALUE - this.fromPosition;
        long l2 = replayLength = length == -1L ? maxLength : Math.min(length, maxLength);
        if (replayLength < 0L) {
            throw new IllegalArgumentException("Length must be positive");
        }
        this.segmentFileIndex = Archive.segmentFileIndex(this.startPosition, this.fromPosition, this.segmentLength);
        if (!this.openRecordingSegment()) {
            throw new IllegalStateException("segment file must be available for requested position: " + position);
        }
        long termStartPosition = this.startPosition / (long)this.termLength * (long)this.termLength;
        long fromSegmentOffset = this.fromPosition - termStartPosition & (long)(this.segmentLength - 1);
        int termMask = this.termLength - 1;
        int fromTermStartSegmentOffset = (int)(fromSegmentOffset - (fromSegmentOffset & (long)termMask));
        int fromTermOffset = (int)(fromSegmentOffset & (long)termMask);
        this.termBuffer = new UnsafeBuffer(this.mappedSegmentBuffer, fromTermStartSegmentOffset, this.termLength);
        this.termStartSegmentOffset = fromTermStartSegmentOffset;
        this.termOffset = fromTermOffset;
        DataHeaderFlyweight flyweight = new DataHeaderFlyweight();
        flyweight.wrap(this.termBuffer, this.termOffset, 32);
        if (flyweight.sessionId() != descriptorDecoder.sessionId() || flyweight.streamId() != descriptorDecoder.streamId() || flyweight.termOffset() != this.termOffset) {
            this.close();
            throw new IllegalArgumentException("fromPosition is not aligned to fragment: " + this.fromPosition);
        }
        this.replayPosition = this.fromPosition;
        this.replayLimit = this.fromPosition + replayLength;
    }

    @Override
    public void close() {
        this.closeRecordingSegment();
    }

    boolean isDone() {
        return this.isDone;
    }

    long fromPosition() {
        return this.fromPosition;
    }

    int controlledPoll(SimplifiedControlledFragmentHandler fragmentHandler, int fragmentLimit) throws IOException {
        int polled;
        if (this.isDone() || this.noAvailableData()) {
            return 0;
        }
        for (polled = 0; this.stopPosition - this.replayPosition > 0L && polled < fragmentLimit; ++polled) {
            if (this.termOffset == this.termLength) {
                this.termOffset = 0;
                this.nextTerm();
                break;
            }
            int frameOffset = this.termOffset;
            int frameLength = FrameDescriptor.frameLength(this.termBuffer, frameOffset);
            int alignedLength = BitUtil.align(frameLength, 32);
            this.replayPosition += (long)alignedLength;
            this.termOffset += alignedLength;
            int dataOffset = frameOffset + 32;
            int dataLength = frameLength - 32;
            if (fragmentHandler.onFragment(this.termBuffer, dataOffset, dataLength)) continue;
            this.replayPosition -= (long)alignedLength;
            this.termOffset -= alignedLength;
            break;
        }
        return polled;
    }

    private boolean noAvailableData() {
        return this.recordingPosition != null && this.replayPosition == this.stopPosition && !this.refreshStopPositionAndLimit(this.replayPosition, this.stopPosition);
    }

    private boolean refreshStopPositionAndLimit(long replayPosition, long oldStopPosition) {
        long newStopPosition;
        long currentRecodingPosition = this.recordingPosition.get();
        UnsafeAccess.UNSAFE.loadFence();
        boolean hasRecordingStopped = this.recordingPosition.isClosed();
        long l = newStopPosition = hasRecordingStopped ? this.descriptorDecoder.stopPosition() : currentRecodingPosition;
        if (hasRecordingStopped && newStopPosition < this.replayLimit) {
            this.replayLimit = newStopPosition;
        }
        if (this.replayLimit <= replayPosition) {
            this.isDone = true;
            return false;
        }
        if (newStopPosition != oldStopPosition) {
            this.stopPosition = newStopPosition;
            return true;
        }
        return false;
    }

    private void nextTerm() throws IOException {
        this.termStartSegmentOffset += this.termLength;
        if (this.termStartSegmentOffset == this.segmentLength) {
            this.closeRecordingSegment();
            ++this.segmentFileIndex;
            if (!this.openRecordingSegment()) {
                throw new IllegalStateException("Failed to open segment file: " + Archive.segmentFileName(this.recordingId, this.segmentFileIndex));
            }
            this.termStartSegmentOffset = 0;
        }
        this.termBuffer.wrap(this.mappedSegmentBuffer, this.termStartSegmentOffset, this.termLength);
    }

    private void closeRecordingSegment() {
        if (null != this.mappedSegmentBuffer) {
            IoUtil.unmap(this.mappedSegmentBuffer);
        }
        this.mappedSegmentBuffer = null;
    }

    private boolean openRecordingSegment() throws IOException {
        String segmentFileName = Archive.segmentFileName(this.recordingId, this.segmentFileIndex);
        File segmentFile = new File(this.archiveDir, segmentFileName);
        if (!segmentFile.exists()) {
            int lastSegmentIndex = Archive.segmentFileIndex(this.startPosition, this.stopPosition, this.segmentLength);
            if (lastSegmentIndex > this.segmentFileIndex) {
                throw new IllegalStateException("Recording segment not found. Segment index=" + this.segmentFileIndex + ", last segment index=" + lastSegmentIndex);
            }
            return false;
        }
        try (FileChannel channel = FileChannel.open(segmentFile.toPath(), StandardOpenOption.READ);){
            this.mappedSegmentBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.segmentLength);
        }
        return true;
    }
}

