/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Publication;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.CloseSessionRequestEncoder;
import io.aeron.archive.codecs.ConnectRequestEncoder;
import io.aeron.archive.codecs.ListRecordingsForUriRequestEncoder;
import io.aeron.archive.codecs.ListRecordingsRequestEncoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.ReplayRequestEncoder;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.codecs.StartRecordingRequestEncoder;
import io.aeron.archive.codecs.StopRecordingRequestEncoder;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.YieldingIdleStrategy;

public class ArchiveProxy {
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 3;
    private final long connectTimeoutNs;
    private final int maxRetryAttempts;
    private final IdleStrategy retryIdleStrategy;
    private final ExpandableDirectByteBuffer buffer = new ExpandableDirectByteBuffer(1024);
    private final Publication publication;
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ConnectRequestEncoder connectRequestEncoder = new ConnectRequestEncoder();
    private final CloseSessionRequestEncoder closeSessionRequestEncoder = new CloseSessionRequestEncoder();
    private final StartRecordingRequestEncoder startRecordingRequestEncoder = new StartRecordingRequestEncoder();
    private final ReplayRequestEncoder replayRequestEncoder = new ReplayRequestEncoder();
    private final StopRecordingRequestEncoder stopRecordingRequestEncoder = new StopRecordingRequestEncoder();
    private final ListRecordingsRequestEncoder listRecordingsRequestEncoder = new ListRecordingsRequestEncoder();
    private final ListRecordingsForUriRequestEncoder listRecordingsForUriRequestEncoder = new ListRecordingsForUriRequestEncoder();

    public ArchiveProxy(Publication publication) {
        this(publication, new YieldingIdleStrategy(), AeronArchive.Configuration.MESSAGE_TIMEOUT_DEFAULT_NS, 3);
    }

    public ArchiveProxy(Publication publication, IdleStrategy retryIdleStrategy, long connectTimeoutNs, int maxRetryAttempts) {
        this.publication = publication;
        this.retryIdleStrategy = retryIdleStrategy;
        this.connectTimeoutNs = connectTimeoutNs;
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public Publication publication() {
        return this.publication;
    }

    public boolean connect(String responseChannel, int responseStreamId, long correlationId) {
        this.connectRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).responseStreamId(responseStreamId).responseChannel(responseChannel);
        return this.offerWithTimeout(this.connectRequestEncoder.encodedLength());
    }

    public boolean closeSession(long controlSessionId) {
        this.closeSessionRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId);
        return this.offer(this.closeSessionRequestEncoder.encodedLength());
    }

    public boolean startRecording(String channel, int streamId, SourceLocation sourceLocation, long correlationId, long controlSessionId) {
        this.startRecordingRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).streamId(streamId).sourceLocation(sourceLocation).channel(channel);
        return this.offer(this.startRecordingRequestEncoder.encodedLength());
    }

    public boolean stopRecording(String channel, int streamId, long correlationId, long controlSessionId) {
        this.stopRecordingRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).streamId(streamId).channel(channel);
        return this.offer(this.stopRecordingRequestEncoder.encodedLength());
    }

    public boolean replay(long recordingId, long position, long length, String replayChannel, int replayStreamId, long correlationId, long controlSessionId) {
        this.replayRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).position(position).length(length).replayStreamId(replayStreamId).replayChannel(replayChannel);
        return this.offer(this.replayRequestEncoder.encodedLength());
    }

    public boolean listRecordings(long fromRecordingId, int recordCount, long correlationId, long controlSessionId) {
        this.listRecordingsRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).fromRecordingId(fromRecordingId).recordCount(recordCount);
        return this.offer(this.listRecordingsRequestEncoder.encodedLength());
    }

    public boolean listRecordingsForUri(long fromRecordingId, int recordCount, String channel, int streamId, long correlationId, long controlSessionId) {
        this.listRecordingsForUriRequestEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).fromRecordingId(fromRecordingId).recordCount(recordCount).streamId(streamId).channel(channel);
        return this.offer(this.listRecordingsForUriRequestEncoder.encodedLength());
    }

    private boolean offer(int length) {
        this.retryIdleStrategy.reset();
        int attempts = 0;
        long result;
        while ((result = this.publication.offer(this.buffer, 0, 8 + length)) <= 0L) {
            if (result == -5L) {
                throw new IllegalStateException("Publication failed due to max position being reached");
            }
            if (++attempts > this.maxRetryAttempts) {
                return false;
            }
            this.retryIdleStrategy.idle();
        }
        return true;
    }

    private boolean offerWithTimeout(int length) {
        this.retryIdleStrategy.reset();
        long timeoutNs = System.nanoTime() + this.connectTimeoutNs;
        while (this.publication.offer(this.buffer, 0, 8 + length) <= 0L) {
            if (System.nanoTime() > timeoutNs) {
                return false;
            }
            this.retryIdleStrategy.idle();
        }
        return true;
    }
}

