/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class ControlResponsePoller {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final RecordingDescriptorDecoder recordingDescriptorDecoder = new RecordingDescriptorDecoder();
    private final int fragmentLimit;
    private final Subscription subscription;
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this::onFragment);
    private long controlSessionId = -1L;
    private long correlationId = -1L;
    private int templateId = -1;
    private boolean pollComplete = false;

    public ControlResponsePoller(Subscription subscription, int fragmentLimit) {
        this.subscription = subscription;
        this.fragmentLimit = fragmentLimit;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public int poll() {
        this.controlSessionId = -1L;
        this.correlationId = -1L;
        this.templateId = -1;
        this.pollComplete = false;
        return this.subscription.controlledPoll(this.fragmentAssembler, this.fragmentLimit);
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public boolean isPollComplete() {
        return this.pollComplete;
    }

    public int templateId() {
        return this.templateId;
    }

    private ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        this.templateId = this.messageHeaderDecoder.templateId();
        switch (this.templateId) {
            case 1: {
                this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.controlSessionId = this.controlResponseDecoder.controlSessionId();
                this.correlationId = this.controlResponseDecoder.correlationId();
                break;
            }
            case 11: {
                this.recordingDescriptorDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.controlSessionId = this.recordingDescriptorDecoder.controlSessionId();
                this.correlationId = this.recordingDescriptorDecoder.correlationId();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown templateId: " + this.templateId);
            }
        }
        this.pollComplete = true;
        return ControlledFragmentHandler.Action.BREAK;
    }

    public MessageHeaderDecoder messageHeaderDecoder() {
        return this.messageHeaderDecoder;
    }

    public ControlResponseDecoder controlResponseDecoder() {
        return this.controlResponseDecoder;
    }

    public RecordingDescriptorDecoder recordingDescriptorDecoder() {
        return this.recordingDescriptorDecoder;
    }
}

