/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.CatalogHeaderDecoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public class CatalogHeaderEncoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 9;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final CatalogHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 9;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public CatalogHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 8);
        return this;
    }

    public CatalogHeaderEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(8).templateId(9).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public CatalogHeaderEncoder version(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int entryLengthEncodingOffset() {
        return 4;
    }

    public static int entryLengthEncodingLength() {
        return 4;
    }

    public static int entryLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int entryLengthMinValue() {
        return -2147483647;
    }

    public static int entryLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public CatalogHeaderEncoder entryLength(int value) {
        this.buffer.putInt(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        CatalogHeaderDecoder writer = new CatalogHeaderDecoder();
        writer.wrap(this.buffer, this.offset, 8, 0);
        return writer.appendTo(builder);
    }
}

