/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.MetaAttribute;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class RecordingDescriptorEncoder {
    public static final int BLOCK_LENGTH = 80;
    public static final int TEMPLATE_ID = 11;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final RecordingDescriptorEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 80;
    }

    public int sbeTemplateId() {
        return 11;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RecordingDescriptorEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 80);
        return this;
    }

    public RecordingDescriptorEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(80).templateId(11).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingDescriptorEncoder controlSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingDescriptorEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int recordingIdEncodingOffset() {
        return 16;
    }

    public static int recordingIdEncodingLength() {
        return 8;
    }

    public static long recordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long recordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingDescriptorEncoder recordingId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int startTimestampEncodingOffset() {
        return 24;
    }

    public static int startTimestampEncodingLength() {
        return 8;
    }

    public static long startTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingDescriptorEncoder startTimestamp(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int stopTimestampEncodingOffset() {
        return 32;
    }

    public static int stopTimestampEncodingLength() {
        return 8;
    }

    public static long stopTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long stopTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long stopTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingDescriptorEncoder stopTimestamp(long value) {
        this.buffer.putLong(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int startPositionEncodingOffset() {
        return 40;
    }

    public static int startPositionEncodingLength() {
        return 8;
    }

    public static long startPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long startPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingDescriptorEncoder startPosition(long value) {
        this.buffer.putLong(this.offset + 40, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int stopPositionEncodingOffset() {
        return 48;
    }

    public static int stopPositionEncodingLength() {
        return 8;
    }

    public static long stopPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long stopPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long stopPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingDescriptorEncoder stopPosition(long value) {
        this.buffer.putLong(this.offset + 48, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int initialTermIdEncodingOffset() {
        return 56;
    }

    public static int initialTermIdEncodingLength() {
        return 4;
    }

    public static int initialTermIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int initialTermIdMinValue() {
        return -2147483647;
    }

    public static int initialTermIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordingDescriptorEncoder initialTermId(int value) {
        this.buffer.putInt(this.offset + 56, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int segmentFileLengthEncodingOffset() {
        return 60;
    }

    public static int segmentFileLengthEncodingLength() {
        return 4;
    }

    public static int segmentFileLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int segmentFileLengthMinValue() {
        return -2147483647;
    }

    public static int segmentFileLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordingDescriptorEncoder segmentFileLength(int value) {
        this.buffer.putInt(this.offset + 60, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int termBufferLengthEncodingOffset() {
        return 64;
    }

    public static int termBufferLengthEncodingLength() {
        return 4;
    }

    public static int termBufferLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int termBufferLengthMinValue() {
        return -2147483647;
    }

    public static int termBufferLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordingDescriptorEncoder termBufferLength(int value) {
        this.buffer.putInt(this.offset + 64, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int mtuLengthEncodingOffset() {
        return 68;
    }

    public static int mtuLengthEncodingLength() {
        return 4;
    }

    public static int mtuLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int mtuLengthMinValue() {
        return -2147483647;
    }

    public static int mtuLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordingDescriptorEncoder mtuLength(int value) {
        this.buffer.putInt(this.offset + 68, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionIdEncodingOffset() {
        return 72;
    }

    public static int sessionIdEncodingLength() {
        return 4;
    }

    public static int sessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sessionIdMinValue() {
        return -2147483647;
    }

    public static int sessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordingDescriptorEncoder sessionId(int value) {
        this.buffer.putInt(this.offset + 72, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int streamIdEncodingOffset() {
        return 76;
    }

    public static int streamIdEncodingLength() {
        return 4;
    }

    public static int streamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int streamIdMinValue() {
        return -2147483647;
    }

    public static int streamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordingDescriptorEncoder streamId(int value) {
        this.buffer.putInt(this.offset + 76, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int strippedChannelId() {
        return 14;
    }

    public static String strippedChannelCharacterEncoding() {
        return "US-ASCII";
    }

    public static String strippedChannelMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int strippedChannelHeaderLength() {
        return 4;
    }

    public RecordingDescriptorEncoder putStrippedChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordingDescriptorEncoder putStrippedChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordingDescriptorEncoder strippedChannel(String value) {
        int length = value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int originalChannelId() {
        return 15;
    }

    public static String originalChannelCharacterEncoding() {
        return "US-ASCII";
    }

    public static String originalChannelMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int originalChannelHeaderLength() {
        return 4;
    }

    public RecordingDescriptorEncoder putOriginalChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordingDescriptorEncoder putOriginalChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordingDescriptorEncoder originalChannel(String value) {
        int length = value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int sourceIdentityId() {
        return 16;
    }

    public static String sourceIdentityCharacterEncoding() {
        return "US-ASCII";
    }

    public static String sourceIdentityMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int sourceIdentityHeaderLength() {
        return 4;
    }

    public RecordingDescriptorEncoder putSourceIdentity(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordingDescriptorEncoder putSourceIdentity(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public RecordingDescriptorEncoder sourceIdentity(String value) {
        int length = value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        RecordingDescriptorDecoder writer = new RecordingDescriptorDecoder();
        writer.wrap(this.buffer, this.offset, 80, 0);
        return writer.appendTo(builder);
    }
}

