/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import java.io.File;
import org.agrona.IoUtil;

class FileMappingConvention {
    public static final String PUBLICATIONS = "publications";
    public static final String IMAGES = "images";
    private final File publicationsDir;
    private final File imagesDir;

    FileMappingConvention(String dataDirName) {
        File dataDir = new File(dataDirName);
        IoUtil.ensureDirectoryExists(dataDir, "data directory");
        this.publicationsDir = new File(dataDir, PUBLICATIONS);
        this.imagesDir = new File(dataDir, IMAGES);
    }

    public File publicationsDir() {
        return this.publicationsDir;
    }

    public File imagesDir() {
        return this.imagesDir;
    }

    public static File streamLocation(File rootDir, String channel, int sessionId, int streamId, long correlationId) {
        String fileName = channel + '-' + Integer.toHexString(sessionId) + '-' + Integer.toHexString(streamId) + '-' + Long.toHexString(correlationId) + ".logbuffer";
        return new File(rootDir, fileName);
    }
}

