/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.Configuration;
import io.aeron.driver.buffer.FileMappingConvention;
import io.aeron.driver.buffer.MappedRawLog;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.errors.DistinctErrorLog;

public class RawLogFactory {
    private final DistinctErrorLog errorLog;
    private final int maxTermBufferLength;
    private final boolean useSparseFiles;
    private final File publicationsDir;
    private final File imagesDir;
    private final FileStore fileStore;

    public RawLogFactory(String dataDirectoryName, int imagesTermBufferMaxLength, boolean useSparseFiles, DistinctErrorLog errorLog) {
        this.errorLog = errorLog;
        this.useSparseFiles = useSparseFiles;
        FileMappingConvention fileMappingConvention = new FileMappingConvention(dataDirectoryName);
        this.publicationsDir = fileMappingConvention.publicationsDir();
        this.imagesDir = fileMappingConvention.imagesDir();
        IoUtil.ensureDirectoryExists(this.publicationsDir, "publications");
        IoUtil.ensureDirectoryExists(this.imagesDir, "images");
        FileStore fs = null;
        try {
            fs = Files.getFileStore(Paths.get(dataDirectoryName, new String[0]));
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        this.fileStore = fs;
        this.maxTermBufferLength = imagesTermBufferMaxLength;
    }

    public RawLog newNetworkPublication(String channel, int sessionId, int streamId, long correlationId, int termBufferLength) {
        return this.newInstance(this.publicationsDir, channel, sessionId, streamId, correlationId, termBufferLength);
    }

    public RawLog newNetworkedImage(String channel, int sessionId, int streamId, long correlationId, int termBufferLength) {
        return this.newInstance(this.imagesDir, channel, sessionId, streamId, correlationId, termBufferLength);
    }

    public RawLog newIpcPublication(int sessionId, int streamId, long correlationId, int termBufferLength) {
        return this.newInstance(this.publicationsDir, "ipc", sessionId, streamId, correlationId, termBufferLength);
    }

    private RawLog newInstance(File rootDir, String channel, int sessionId, int streamId, long correlationId, int termBufferLength) {
        this.validateTermBufferLength(termBufferLength);
        long usableSpace = this.getUsableSpace();
        long logLength = LogBufferDescriptor.computeLogLength(termBufferLength);
        if (usableSpace <= Configuration.LOW_FILE_STORE_WARNING_THRESHOLD) {
            System.out.format("Warning: space is running low in %s threshold=%,d usable=%,d%n", this.fileStore, Configuration.LOW_FILE_STORE_WARNING_THRESHOLD, usableSpace);
        }
        if (usableSpace < logLength) {
            throw new IllegalStateException("Insufficient usable storage for new log of length=" + logLength + " in " + this.fileStore);
        }
        File location = FileMappingConvention.streamLocation(rootDir, channel, sessionId, streamId, correlationId);
        return new MappedRawLog(location, this.useSparseFiles, termBufferLength, this.errorLog);
    }

    private long getUsableSpace() {
        long usableSpace = 0L;
        try {
            usableSpace = this.fileStore.getUsableSpace();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return usableSpace;
    }

    private void validateTermBufferLength(int termBufferLength) {
        if (termBufferLength < 0 || termBufferLength > this.maxTermBufferLength) {
            throw new IllegalArgumentException("invalid buffer length: " + termBufferLength + " max is " + this.maxTermBufferLength);
        }
    }
}

