/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CommonContext;
import io.aeron.driver.reports.LossReportReader;
import io.aeron.driver.reports.LossReportUtil;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class LossStat {
    public static void main(String[] args) {
        String aeronDirectoryName = System.getProperty("aeron.dir", CommonContext.AERON_DIR_PROP_DEFAULT);
        File lossReportFile = LossReportUtil.file(aeronDirectoryName);
        if (!lossReportFile.exists()) {
            System.err.print("Loss report does not exist: " + lossReportFile);
            System.exit(1);
        }
        MappedByteBuffer mappedByteBuffer = IoUtil.mapExistingFile(lossReportFile, "Loss Report");
        UnsafeBuffer buffer = new UnsafeBuffer(mappedByteBuffer);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        System.out.println("#OBSERVATION_COUNT, TOTAL_BYTES_LOST, FIRST_OBSERVATION, LAST_OBSERVATION, SESSION_ID, STREAM_ID, CHANNEL, SOURCE");
        int entriesRead = LossReportReader.read(buffer, (observationCount, totalBytesLost, firstObservationTimestamp, lastObservationTimestamp, sessionId, streamId, channel, source) -> System.out.format("%d,%d,%s,%s,%d,%d,%s,%s%n", observationCount, totalBytesLost, dateFormat.format(new Date(firstObservationTimestamp)), dateFormat.format(new Date(lastObservationTimestamp)), sessionId, streamId, channel, source));
        System.out.println(entriesRead + " entries read");
    }
}

