/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.samples.SampleConfiguration;
import io.aeron.shadow.org.HdrHistogram.Histogram;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.console.ContinueBarrier;

public class Ping {
    private static final int PING_STREAM_ID = SampleConfiguration.PING_STREAM_ID;
    private static final int PONG_STREAM_ID = SampleConfiguration.PONG_STREAM_ID;
    private static final int NUMBER_OF_MESSAGES = SampleConfiguration.NUMBER_OF_MESSAGES;
    private static final int WARMUP_NUMBER_OF_MESSAGES = SampleConfiguration.WARMUP_NUMBER_OF_MESSAGES;
    private static final int WARMUP_NUMBER_OF_ITERATIONS = SampleConfiguration.WARMUP_NUMBER_OF_ITERATIONS;
    private static final int MESSAGE_LENGTH = SampleConfiguration.MESSAGE_LENGTH;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final boolean EMBEDDED_MEDIA_DRIVER = SampleConfiguration.EMBEDDED_MEDIA_DRIVER;
    private static final String PING_CHANNEL = SampleConfiguration.PING_CHANNEL;
    private static final String PONG_CHANNEL = SampleConfiguration.PONG_CHANNEL;
    private static final UnsafeBuffer ATOMIC_BUFFER = new UnsafeBuffer(BufferUtil.allocateDirectAligned(MESSAGE_LENGTH, 64));
    private static final Histogram HISTOGRAM = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
    private static final CountDownLatch LATCH = new CountDownLatch(1);
    private static final IdleStrategy POLLING_IDLE_STRATEGY = new BusySpinIdleStrategy();

    public static void main(String[] args) throws Exception {
        MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded() : null;
        Aeron.Context ctx = new Aeron.Context().availableImageHandler(Ping::availablePongImageHandler);
        FragmentAssembler fragmentHandler = new FragmentAssembler(Ping::pongHandler);
        if (EMBEDDED_MEDIA_DRIVER) {
            ctx.aeronDirectoryName(driver.aeronDirectoryName());
        }
        System.out.println("Publishing Ping at " + PING_CHANNEL + " on stream Id " + PING_STREAM_ID);
        System.out.println("Subscribing Pong at " + PONG_CHANNEL + " on stream Id " + PONG_STREAM_ID);
        System.out.println("Message length of " + MESSAGE_LENGTH + " bytes");
        try (Aeron aeron = Aeron.connect(ctx);){
            System.out.println("Warming up... " + WARMUP_NUMBER_OF_ITERATIONS + " iterations of " + WARMUP_NUMBER_OF_MESSAGES + " messages");
            try (Publication publication = aeron.addPublication(PING_CHANNEL, PING_STREAM_ID);
                 Subscription subscription = aeron.addSubscription(PONG_CHANNEL, PONG_STREAM_ID);){
                LATCH.await();
                for (int i = 0; i < WARMUP_NUMBER_OF_ITERATIONS; ++i) {
                    Ping.roundTripMessages(fragmentHandler, publication, subscription, WARMUP_NUMBER_OF_MESSAGES);
                }
                Thread.sleep(100L);
                ContinueBarrier barrier = new ContinueBarrier("Execute again?");
                do {
                    HISTOGRAM.reset();
                    System.out.println("Pinging " + NUMBER_OF_MESSAGES + " messages");
                    Ping.roundTripMessages(fragmentHandler, publication, subscription, NUMBER_OF_MESSAGES);
                    System.out.println("Histogram of RTT latencies in microseconds.");
                    HISTOGRAM.outputPercentileDistribution(System.out, 1000.0);
                } while (barrier.await());
            }
        }
        CloseHelper.quietClose(driver);
    }

    private static void roundTripMessages(FragmentHandler fragmentHandler, Publication publication, Subscription subscription, int count) {
        while (subscription.hasNoImages()) {
            Thread.yield();
        }
        Image image = subscription.imageAtIndex(0);
        block1: for (int i = 0; i < count; ++i) {
            long offeredPosition;
            do {
                ATOMIC_BUFFER.putLong(0, System.nanoTime());
            } while ((offeredPosition = publication.offer(ATOMIC_BUFFER, 0, MESSAGE_LENGTH)) < 0L);
            POLLING_IDLE_STRATEGY.reset();
            while (true) {
                if (image.poll(fragmentHandler, FRAGMENT_COUNT_LIMIT) <= 0) {
                    POLLING_IDLE_STRATEGY.idle();
                    continue;
                }
                if (image.position() >= offeredPosition) continue block1;
            }
        }
    }

    private static void pongHandler(DirectBuffer buffer, int offset, int length, Header header) {
        long pingTimestamp = buffer.getLong(offset);
        long rttNs = System.nanoTime() - pingTimestamp;
        HISTOGRAM.recordValue(rttNs);
    }

    private static void availablePongImageHandler(Image image) {
        Subscription subscription = image.subscription();
        System.out.format("Available image: channel=%s streamId=%d session=%d%n", subscription.channel(), subscription.streamId(), image.sessionId());
        if (PONG_STREAM_ID == subscription.streamId() && PONG_CHANNEL.equals(subscription.channel())) {
            LATCH.countDown();
        }
    }
}

