/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import java.util.concurrent.locks.LockSupport;

public class RateReporter
implements Runnable {
    private final long reportIntervalNs;
    private final long parkNs;
    private long lastTotalBytes;
    private long lastTotalMessages;
    private long lastTimestamp;
    private volatile long totalBytes;
    private volatile long totalMessages;
    private volatile boolean halt = false;
    private final Reporter reportingFunc;

    public RateReporter(long reportInterval, Reporter reportingFunc) {
        this.reportIntervalNs = reportInterval;
        this.parkNs = reportInterval;
        this.reportingFunc = reportingFunc;
        this.lastTimestamp = System.nanoTime();
    }

    @Override
    public void run() {
        do {
            LockSupport.parkNanos(this.parkNs);
            long currentTotalMessages = this.totalMessages;
            long currentTotalBytes = this.totalBytes;
            long currentTimestamp = System.nanoTime();
            long timeSpanNs = currentTimestamp - this.lastTimestamp;
            double messagesPerSec = (double)((currentTotalMessages - this.lastTotalMessages) * this.reportIntervalNs) / (double)timeSpanNs;
            double bytesPerSec = (double)((currentTotalBytes - this.lastTotalBytes) * this.reportIntervalNs) / (double)timeSpanNs;
            this.reportingFunc.onReport(messagesPerSec, bytesPerSec, currentTotalMessages, currentTotalBytes);
            this.lastTotalBytes = currentTotalBytes;
            this.lastTotalMessages = currentTotalMessages;
            this.lastTimestamp = currentTimestamp;
        } while (!this.halt);
    }

    public void halt() {
        this.halt = true;
    }

    public void onMessage(long messages, long bytes) {
        this.totalBytes += bytes;
        this.totalMessages += messages;
    }

    @FunctionalInterface
    public static interface Reporter {
        public void onReport(double var1, double var3, long var5, long var7);
    }
}

