/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.concurrent.SigInt;

public class ReceiveWriteUdpPong {
    public static void main(String[] args) throws IOException {
        int numChannels = 1;
        if (1 == args.length) {
            numChannels = Integer.parseInt(args[0]);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        DatagramChannel[] receiveChannels = new DatagramChannel[numChannels];
        for (int i = 0; i < receiveChannels.length; ++i) {
            receiveChannels[i] = DatagramChannel.open();
            Common.init(receiveChannels[i]);
            receiveChannels[i].bind(new InetSocketAddress("localhost", 50123 + i));
        }
        InetSocketAddress writeAddress = new InetSocketAddress("localhost", 40123);
        DatagramChannel writeChannel = DatagramChannel.open();
        Common.init(writeChannel, writeAddress);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (true) {
            buffer.clear();
            boolean available = false;
            block2: while (!available) {
                if (!running.get()) {
                    return;
                }
                for (int i = receiveChannels.length - 1; i >= 0; --i) {
                    if (null == receiveChannels[i].receive(buffer)) continue;
                    available = true;
                    continue block2;
                }
            }
            long receivedSequenceNumber = buffer.getLong(0);
            long receivedTimestamp = buffer.getLong(8);
            buffer.clear();
            buffer.putLong(receivedSequenceNumber);
            buffer.putLong(receivedTimestamp);
            buffer.flip();
            writeChannel.write(buffer);
        }
    }
}

