/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import org.agrona.concurrent.IdleStrategy;

public final class SleepingMillisIdleStrategy
implements IdleStrategy {
    private final long sleepPeriodMs;

    public SleepingMillisIdleStrategy(long sleepPeriodMs) {
        this.sleepPeriodMs = sleepPeriodMs;
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            return;
        }
        try {
            Thread.sleep(this.sleepPeriodMs);
        }
        catch (InterruptedException ignore) {
            Thread.interrupted();
        }
    }

    @Override
    public void idle() {
        try {
            Thread.sleep(this.sleepPeriodMs);
        }
        catch (InterruptedException ignore) {
            Thread.interrupted();
        }
    }

    @Override
    public void reset() {
    }
}

