/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class PrimitiveExpander {
    private static final String SOURCE_DIRECTORY = "src/main/java/";
    private static final String COLLECTIONS = "org/agrona/collections";
    private static final String SUFFIX = ".java";
    private static final String GENERATED_DIRECTORY = "build/generated-src";
    private static final List<Substitution> SUBSTITUTIONS = Collections.singletonList(new Substitution("long", "Long", "Long"));

    public static void main(String[] args) throws IOException {
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "IntIntConsumer");
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "IntArrayList");
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "IntIterator");
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "Int2IntHashMap");
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "Int2IntCounterMap");
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "IntHashSet");
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "IntLruCache");
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "Int2ObjectCache");
        PrimitiveExpander.expandPrimitiveSpecialisedClass(COLLECTIONS, "Int2ObjectHashMap");
    }

    private static void expandPrimitiveSpecialisedClass(String packageName, String className) throws IOException {
        Path inputPath = Paths.get(SOURCE_DIRECTORY, packageName, className + SUFFIX);
        Path outputDirectory = Paths.get(GENERATED_DIRECTORY, packageName);
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        List<String> contents = Files.readAllLines(inputPath, StandardCharsets.UTF_8);
        for (Substitution substitution : SUBSTITUTIONS) {
            String substitutedFileName = substitution.substitute(className);
            List substitutedContents = contents.stream().map(substitution::checkedSubstitute).collect(Collectors.toList());
            Path outputPath = Paths.get(GENERATED_DIRECTORY, packageName, substitutedFileName + SUFFIX);
            Files.write(outputPath, substitutedContents, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    public static final class Substitution {
        private final String primitiveType;
        private final String boxedType;
        private final String className;

        private Substitution(String primitiveType, String boxedType, String className) {
            this.primitiveType = primitiveType;
            this.boxedType = boxedType;
            this.className = className;
        }

        public String substitute(String contents) {
            return contents.replace("int", this.primitiveType).replace("Integer", this.boxedType).replace("Int", this.className);
        }

        public String checkedSubstitute(String contents) {
            return contents.contains("@DoNotSub") || contents.contains("interface") || contents.contains("Interface") ? contents : this.substitute(contents);
        }
    }
}

