/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.OptimalMulticastDelayGenerator;
import io.aeron.driver.ReceiveChannelEndpointSupplier;
import io.aeron.driver.SendChannelEndpointSupplier;
import io.aeron.driver.StaticDelayGenerator;
import io.aeron.driver.ThreadingMode;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public class Configuration {
    private static final String DEFAULT_IDLE_STRATEGY = "org.agrona.concurrent.BackoffIdleStrategy";
    public static final String RECEIVE_BUFFER_LENGTH_PROP_NAME = "aeron.rcv.buffer.length";
    public static final String TERM_BUFFER_LENGTH_PROP_NAME = "aeron.term.buffer.length";
    public static final String TERM_BUFFER_MAX_LENGTH_PROP_NAME = "aeron.term.buffer.max.length";
    public static final String CONDUCTOR_BUFFER_LENGTH_PROP_NAME = "aeron.conductor.buffer.length";
    public static final String TO_CLIENTS_BUFFER_LENGTH_PROP_NAME = "aeron.clients.buffer.length";
    public static final String COUNTERS_VALUES_BUFFER_LENGTH_PROP_NAME = "aeron.counters.buffer.length";
    public static final String ERROR_BUFFER_LENGTH_PROP_NAME = "aeron.error.buffer.length";
    public static final String INITIAL_WINDOW_LENGTH_PROP_NAME = "aeron.rcv.initial.window.length";
    public static final String STATUS_MESSAGE_TIMEOUT_PROP_NAME = "aeron.rcv.status.message.timeout";
    public static final String SOCKET_RCVBUF_LENGTH_PROP_NAME = "aeron.socket.so_rcvbuf";
    public static final String SOCKET_SNDBUF_LENGTH_PROP_NAME = "aeron.socket.so_sndbuf";
    public static final String SOCKET_MULTICAST_TTL_PROP_NAME = "aeron.socket.multicast.ttl";
    public static final String PUBLICATION_LINGER_PROP_NAME = "aeron.publication.linger.timeout";
    public static final String PUBLICATION_TERM_WINDOW_LENGTH_PROP_NAME = "aeron.publication.term.window.length";
    public static final int PUBLICATION_TERM_WINDOW_LENGTH = Integer.getInteger("aeron.publication.term.window.length", 0);
    public static final String CLIENT_LIVENESS_TIMEOUT_PROP_NAME = "aeron.client.liveness.timeout";
    public static final String IMAGE_LIVENESS_TIMEOUT_PROP_NAME = "aeron.image.liveness.timeout";
    public static final String PUBLICATION_UNBLOCK_TIMEOUT_PROP_NAME = "aeron.publication.unblock.timeout";
    public static final String TERM_BUFFER_SPARSE_FILE_PROP_NAME = "aeron.term.buffer.sparse.file";
    public static final String TERM_BUFFER_SPARSE_FILE = System.getProperty("aeron.term.buffer.sparse.file");
    public static final int TERM_BUFFER_IPC_LENGTH_DEFAULT = 0x4000000;
    public static final String IPC_TERM_BUFFER_LENGTH_PROP_NAME = "aeron.ipc.term.buffer.length";
    public static final int IPC_TERM_BUFFER_LENGTH = Integer.getInteger("aeron.ipc.term.buffer.length", 0x4000000);
    public static final String IPC_PUBLICATION_TERM_WINDOW_LENGTH_PROP_NAME = "aeron.ipc.publication.term.window.length";
    public static final int IPC_PUBLICATION_TERM_WINDOW_LENGTH = Integer.getInteger("aeron.ipc.publication.term.window.length", 0);
    public static final int RECEIVE_BYTE_BUFFER_LENGTH_DEFAULT = 4096;
    public static final int RECEIVE_BYTE_BUFFER_LENGTH = Integer.getInteger("aeron.rcv.buffer.length", 4096);
    public static final int TERM_BUFFER_LENGTH_DEFAULT = 0x1000000;
    public static final int TERM_BUFFER_LENGTH_MAX_DEFAULT = 0x1000000;
    public static final int CONDUCTOR_BUFFER_LENGTH_DEFAULT = 0x100000 + RingBufferDescriptor.TRAILER_LENGTH;
    public static final int CONDUCTOR_BUFFER_LENGTH = Integer.getInteger("aeron.conductor.buffer.length", CONDUCTOR_BUFFER_LENGTH_DEFAULT);
    public static final int TO_CLIENTS_BUFFER_LENGTH_DEFAULT = 0x100000 + BroadcastBufferDescriptor.TRAILER_LENGTH;
    public static final int TO_CLIENTS_BUFFER_LENGTH = Integer.getInteger("aeron.clients.buffer.length", TO_CLIENTS_BUFFER_LENGTH_DEFAULT);
    public static final int COUNTERS_VALUES_BUFFER_LENGTH_DEFAULT = 0x100000;
    public static final int COUNTERS_VALUES_BUFFER_LENGTH = Integer.getInteger("aeron.counters.buffer.length", 0x100000);
    public static final int COUNTERS_METADATA_BUFFER_LENGTH = COUNTERS_VALUES_BUFFER_LENGTH * 2;
    public static final int ERROR_BUFFER_LENGTH_DEFAULT = 0x100000;
    public static final int ERROR_BUFFER_LENGTH = Integer.getInteger("aeron.error.buffer.length", 0x100000);
    public static final int NAK_GROUPSIZE_DEFAULT = 10;
    public static final int NAK_GRTT_DEFAULT = 10;
    public static final long NAK_MAX_BACKOFF_DEFAULT = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final OptimalMulticastDelayGenerator NAK_MULTICAST_DELAY_GENERATOR = new OptimalMulticastDelayGenerator(NAK_MAX_BACKOFF_DEFAULT, 10.0, 10.0);
    public static final long NAK_UNICAST_DELAY_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final StaticDelayGenerator NAK_UNICAST_DELAY_GENERATOR = new StaticDelayGenerator(NAK_UNICAST_DELAY_DEFAULT_NS, true);
    public static final long RETRANSMIT_UNICAST_DELAY_DEFAULT_NS = TimeUnit.NANOSECONDS.toNanos(0L);
    public static final FeedbackDelayGenerator RETRANSMIT_UNICAST_DELAY_GENERATOR = () -> RETRANSMIT_UNICAST_DELAY_DEFAULT_NS;
    public static final long RETRANSMIT_UNICAST_LINGER_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(60L);
    public static final FeedbackDelayGenerator RETRANSMIT_UNICAST_LINGER_GENERATOR = () -> RETRANSMIT_UNICAST_LINGER_DEFAULT_NS;
    public static final int MAX_RETRANSMITS_DEFAULT = 16;
    public static final int INITIAL_WINDOW_LENGTH_DEFAULT = 131072;
    public static final long STATUS_MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    public static final int SOCKET_RCVBUF_LENGTH_DEFAULT = 131072;
    public static final int SOCKET_RCVBUF_LENGTH = Integer.getInteger("aeron.socket.so_rcvbuf", 131072);
    public static final int SOCKET_SNDBUF_LENGTH_DEFAULT = 0;
    public static final int SOCKET_SNDBUF_LENGTH = Integer.getInteger("aeron.socket.so_sndbuf", 0);
    public static final int SOCKET_MULTICAST_TTL_DEFAULT = 0;
    public static final int SOCKET_MULTICAST_TTL = Integer.getInteger("aeron.socket.multicast.ttl", 0);
    public static final long PUBLICATION_LINGER_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
    public static final long PUBLICATION_LINGER_NS = Long.getLong("aeron.publication.linger.timeout", PUBLICATION_LINGER_DEFAULT_NS);
    public static final long CLIENT_LIVENESS_TIMEOUT_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(5000L);
    public static final long CLIENT_LIVENESS_TIMEOUT_NS = Long.getLong("aeron.client.liveness.timeout", CLIENT_LIVENESS_TIMEOUT_DEFAULT_NS);
    public static final long IMAGE_LIVENESS_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final long IMAGE_LIVENESS_TIMEOUT_NS = Long.getLong("aeron.image.liveness.timeout", IMAGE_LIVENESS_TIMEOUT_DEFAULT_NS);
    public static final long PUBLICATION_UNBLOCK_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final long PUBLICATION_UNBLOCK_TIMEOUT_NS = Long.getLong("aeron.publication.unblock.timeout", PUBLICATION_UNBLOCK_TIMEOUT_DEFAULT_NS);
    public static final long AGENT_IDLE_MAX_SPINS = 20L;
    public static final long AGENT_IDLE_MAX_YIELDS = 50L;
    public static final long AGENT_IDLE_MIN_PARK_NS = TimeUnit.NANOSECONDS.toNanos(1L);
    public static final long AGENT_IDLE_MAX_PARK_NS = TimeUnit.MICROSECONDS.toNanos(100L);
    public static final String SENDER_IDLE_STRATEGY_PROP_NAME = "aeron.sender.idle.strategy";
    public static final String SENDER_IDLE_STRATEGY = System.getProperty("aeron.sender.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String CONDUCTOR_IDLE_STRATEGY_PROP_NAME = "aeron.conductor.idle.strategy";
    public static final String CONDUCTOR_IDLE_STRATEGY = System.getProperty("aeron.conductor.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String RECEIVER_IDLE_STRATEGY_PROP_NAME = "aeron.receiver.idle.strategy";
    public static final String RECEIVER_IDLE_STRATEGY = System.getProperty("aeron.receiver.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String SHARED_NETWORK_IDLE_STRATEGY_PROP_NAME = "aeron.sharednetwork.idle.strategy";
    public static final String SHARED_NETWORK_IDLE_STRATEGY = System.getProperty("aeron.sharednetwork.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final String SHARED_IDLE_STRATEGY_PROP_NAME = "aeron.shared.idle.strategy";
    public static final String SHARED_IDLE_STRATEGY = System.getProperty("aeron.shared.idle.strategy", "org.agrona.concurrent.BackoffIdleStrategy");
    public static final int CMD_QUEUE_CAPACITY = 1024;
    public static final long PENDING_SETUPS_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
    public static final long PUBLICATION_SETUP_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    public static final long PUBLICATION_HEARTBEAT_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_PROP_NAME = "aeron.unicast.flow.control.strategy";
    public static final String UNICAST_FLOW_CONTROL_STRATEGY = System.getProperty("aeron.unicast.flow.control.strategy", "io.aeron.driver.UnicastFlowControl");
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_PROP_NAME = "aeron.multicast.flow.control.strategy";
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY = System.getProperty("aeron.multicast.flow.control.strategy", "io.aeron.driver.MaxMulticastFlowControl");
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_PROP_NAME = "aeron.unicast.FlowControl.supplier";
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_DEFAULT = "io.aeron.driver.DefaultUnicastFlowControlSupplier";
    public static final String UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER = System.getProperty("aeron.unicast.FlowControl.supplier", "io.aeron.driver.DefaultUnicastFlowControlSupplier");
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_PROP_NAME = "aeron.multicast.FlowControl.supplier";
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER_DEFAULT = "io.aeron.driver.DefaultMulticastFlowControlSupplier";
    public static final String MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER = System.getProperty("aeron.multicast.FlowControl.supplier", "io.aeron.driver.DefaultMulticastFlowControlSupplier");
    public static final String MTU_LENGTH_PROP_NAME = "aeron.mtu.length";
    public static final int MTU_LENGTH_DEFAULT = 4096;
    public static final int MTU_LENGTH = Integer.getInteger("aeron.mtu.length", 4096);
    public static final String THREADING_MODE_PROP_NAME = "aeron.threading.mode";
    public static final String THREADING_MODE_DEFAULT = ThreadingMode.DEDICATED.name();
    public static final long HEARTBEAT_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(1L);
    public static final String SEND_CHANNEL_ENDPOINT_SUPPLIER_PROP_NAME = "aeron.SendChannelEndpoint.supplier";
    public static final String SEND_CHANNEL_ENDPOINT_SUPPLIER_DEFAULT = "io.aeron.driver.DefaultSendChannelEndpointSupplier";
    public static final String SEND_CHANNEL_ENDPOINT_SUPPLIER = System.getProperty("aeron.SendChannelEndpoint.supplier", "io.aeron.driver.DefaultSendChannelEndpointSupplier");
    public static final String RECEIVE_CHANNEL_ENDPOINT_SUPPLIER_PROP_NAME = "aeron.ReceiveChannelEndpoint.supplier";
    public static final String RECEIVE_CHANNEL_ENDPOINT_SUPPLIER_DEFAULT = "io.aeron.driver.DefaultReceiveChannelEndpointSupplier";
    public static final String RECEIVE_CHANNEL_ENDPOINT_SUPPLIER = System.getProperty("aeron.ReceiveChannelEndpoint.supplier", "io.aeron.driver.DefaultReceiveChannelEndpointSupplier");

    public static int publicationTermWindowLength(int termBufferLength) {
        return 0 != PUBLICATION_TERM_WINDOW_LENGTH ? PUBLICATION_TERM_WINDOW_LENGTH : termBufferLength / 2;
    }

    public static void validateTermBufferLength(int length) {
        if (!BitUtil.isPowerOfTwo((int)length)) {
            throw new IllegalStateException("Term buffer length must be a positive power of 2: " + length);
        }
    }

    public static void validateInitialWindowLength(int initialWindowLength, int mtuLength) {
        if (mtuLength > initialWindowLength) {
            throw new IllegalStateException("Initial window length must be >= to MTU length: " + mtuLength);
        }
    }

    public static IdleStrategy agentIdleStrategy(String name) {
        IdleStrategy idleStrategy = null;
        if (name.equals(DEFAULT_IDLE_STRATEGY)) {
            idleStrategy = new BackoffIdleStrategy(20L, 50L, AGENT_IDLE_MIN_PARK_NS, AGENT_IDLE_MAX_PARK_NS);
        } else {
            try {
                idleStrategy = (IdleStrategy)Class.forName(name).newInstance();
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
        return idleStrategy;
    }

    public static IdleStrategy senderIdleStrategy() {
        return Configuration.agentIdleStrategy(SENDER_IDLE_STRATEGY);
    }

    public static IdleStrategy conductorIdleStrategy() {
        return Configuration.agentIdleStrategy(CONDUCTOR_IDLE_STRATEGY);
    }

    public static IdleStrategy receiverIdleStrategy() {
        return Configuration.agentIdleStrategy(RECEIVER_IDLE_STRATEGY);
    }

    public static IdleStrategy sharedNetworkIdleStrategy() {
        return Configuration.agentIdleStrategy(SHARED_NETWORK_IDLE_STRATEGY);
    }

    public static IdleStrategy sharedIdleStrategy() {
        return Configuration.agentIdleStrategy(SHARED_IDLE_STRATEGY);
    }

    public static int termBufferLength() {
        return Integer.getInteger(TERM_BUFFER_LENGTH_PROP_NAME, 0x1000000);
    }

    public static int maxTermBufferLength() {
        return Integer.getInteger(TERM_BUFFER_MAX_LENGTH_PROP_NAME, 0x1000000);
    }

    public static int initialWindowLength() {
        return Integer.getInteger(INITIAL_WINDOW_LENGTH_PROP_NAME, 131072);
    }

    public static long statusMessageTimeout() {
        return Long.getLong(STATUS_MESSAGE_TIMEOUT_PROP_NAME, STATUS_MESSAGE_TIMEOUT_DEFAULT_NS);
    }

    public static ThreadingMode threadingMode() {
        return ThreadingMode.valueOf(System.getProperty(THREADING_MODE_PROP_NAME, THREADING_MODE_DEFAULT));
    }

    public static int ipcTermBufferLength(int termBufferLength) {
        return 0 != IPC_TERM_BUFFER_LENGTH ? IPC_TERM_BUFFER_LENGTH : termBufferLength;
    }

    public static int ipcPublicationTermWindowLength(int termBufferLength) {
        return 0 != IPC_PUBLICATION_TERM_WINDOW_LENGTH ? IPC_PUBLICATION_TERM_WINDOW_LENGTH : termBufferLength / 2;
    }

    public static SendChannelEndpointSupplier sendChannelEndpointSupplier() {
        SendChannelEndpointSupplier supplier = null;
        try {
            supplier = (SendChannelEndpointSupplier)Class.forName(SEND_CHANNEL_ENDPOINT_SUPPLIER).newInstance();
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }

    public static ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier() {
        ReceiveChannelEndpointSupplier supplier = null;
        try {
            supplier = (ReceiveChannelEndpointSupplier)Class.forName(RECEIVE_CHANNEL_ENDPOINT_SUPPLIER).newInstance();
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }

    public static FlowControlSupplier unicastFlowControlSupplier() {
        FlowControlSupplier supplier = null;
        try {
            supplier = (FlowControlSupplier)Class.forName(UNICAST_FLOW_CONTROL_STRATEGY_SUPPLIER).newInstance();
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }

    public static FlowControlSupplier multicastFlowControlSupplier() {
        FlowControlSupplier supplier = null;
        try {
            supplier = (FlowControlSupplier)Class.forName(MULTICAST_FLOW_CONTROL_STRATEGY_SUPPLIER).newInstance();
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return supplier;
    }
}

