/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferPartition;
import io.aeron.logbuffer.LogBufferUnblocker;
import java.util.ArrayList;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public class DirectPublication
implements DriverManagedResource {
    private final long correlationId;
    private final long tripGain;
    private long tripLimit = 0L;
    private final int sessionId;
    private final int streamId;
    private final int termWindowLength;
    private final int positionBitsToShift;
    private final LogBufferPartition[] logPartitions;
    private final ArrayList<ReadablePosition> subscriberPositions = new ArrayList();
    private final RawLog rawLog;
    private final Position publisherLimit;
    private long consumerPosition = 0L;
    private int refCount = 0;
    private boolean reachedEndOfLife = false;

    public DirectPublication(long correlationId, int sessionId, int streamId, Position publisherLimit, RawLog rawLog) {
        this.correlationId = correlationId;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.logPartitions = rawLog.partitions();
        int termLength = rawLog.termLength();
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        this.termWindowLength = Configuration.ipcPublicationTermWindowLength(termLength);
        this.tripGain = this.termWindowLength / 8;
        this.publisherLimit = publisherLimit;
        this.rawLog = rawLog;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public RawLog rawLog() {
        return this.rawLog;
    }

    public int publisherLimitId() {
        return this.publisherLimit.id();
    }

    public void close() {
        this.rawLog.close();
        this.publisherLimit.close();
        this.subscriberPositions.forEach(ReadablePosition::close);
    }

    public void addSubscription(ReadablePosition subscriberPosition) {
        this.subscriberPositions.add(subscriberPosition);
    }

    public void removeSubscription(ReadablePosition subscriberPosition) {
        this.subscriberPositions.remove(subscriberPosition);
        subscriberPosition.close();
    }

    public int updatePublishersLimit(long nowInMillis) {
        int workCount = 0;
        long minSubscriberPosition = Long.MAX_VALUE;
        long maxSubscriberPosition = 0L;
        ArrayList<ReadablePosition> subscriberPositions = this.subscriberPositions;
        int size = subscriberPositions.size();
        for (int i = 0; i < size; ++i) {
            long position = ((ReadablePosition)subscriberPositions.get(i)).getVolatile();
            minSubscriberPosition = Math.min(minSubscriberPosition, position);
            maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
        }
        long proposedLimit = 0L;
        if (!subscriberPositions.isEmpty()) {
            proposedLimit = minSubscriberPosition + (long)this.termWindowLength;
            LogBufferDescriptor.timeOfLastStatusMessage((UnsafeBuffer)this.rawLog.logMetaData(), (long)nowInMillis);
        }
        if (proposedLimit > this.tripLimit) {
            this.publisherLimit.setOrdered(proposedLimit);
            this.tripLimit = proposedLimit + this.tripGain;
            workCount = 1;
        }
        this.consumerPosition = maxSubscriberPosition;
        return workCount;
    }

    public int cleanLogBuffer() {
        int workCount = 0;
        for (LogBufferPartition partition : this.logPartitions) {
            if (partition.status() != 1) continue;
            partition.clean();
            workCount = 1;
        }
        return workCount;
    }

    public long joiningPosition() {
        long maxSubscriberPosition = this.producerPosition();
        ArrayList<ReadablePosition> subscriberPositions = this.subscriberPositions;
        int size = subscriberPositions.size();
        for (int i = 0; i < size; ++i) {
            long position = ((ReadablePosition)subscriberPositions.get(i)).getVolatile();
            maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
        }
        return maxSubscriberPosition;
    }

    @Override
    public long producerPosition() {
        UnsafeBuffer logMetaDataBuffer = this.rawLog.logMetaData();
        int initialTermId = LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaDataBuffer);
        long rawTail = this.logPartitions[LogBufferDescriptor.activePartitionIndex((UnsafeBuffer)logMetaDataBuffer)].rawTailVolatile();
        int termOffset = LogBufferDescriptor.termOffset((long)rawTail, (long)this.rawLog.termLength());
        return LogBufferDescriptor.computePosition((int)LogBufferDescriptor.termId((long)rawTail), (int)termOffset, (int)this.positionBitsToShift, (int)initialTermId);
    }

    @Override
    public void onTimeEvent(long time, DriverConductor conductor) {
        if (0 == this.refCount) {
            this.reachedEndOfLife = true;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
        throw new UnsupportedOperationException("not used");
    }

    public long timeOfLastStateChange() {
        throw new UnsupportedOperationException("not used");
    }

    public void delete() {
        this.close();
    }

    @Override
    public int incRef() {
        return ++this.refCount;
    }

    @Override
    public int decRef() {
        return --this.refCount;
    }

    @Override
    public long consumerPosition() {
        return this.consumerPosition;
    }

    @Override
    public boolean unblockAtConsumerPosition() {
        return LogBufferUnblocker.unblock((LogBufferPartition[])this.logPartitions, (UnsafeBuffer)this.rawLog.logMetaData(), (long)this.consumerPosition);
    }
}

