/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.LossDetector;
import io.aeron.driver.NakMessageSender;
import io.aeron.driver.PublicationImagePadding4;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermRebuilder;
import java.net.InetSocketAddress;
import java.util.List;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public class PublicationImage
extends PublicationImagePadding4
implements NakMessageSender,
DriverManagedResource {
    private final long correlationId;
    private final long imageLivenessTimeoutNs;
    private final int sessionId;
    private final int streamId;
    private final int positionBitsToShift;
    private final int termLengthMask;
    private final int initialTermId;
    private final int currentWindowLength;
    private final int currentGain;
    private final RawLog rawLog;
    private final InetSocketAddress controlAddress;
    private final InetSocketAddress sourceAddress;
    private final ReceiveChannelEndpoint channelEndpoint;
    private final NanoClock clock;
    private final UnsafeBuffer[] termBuffers = new UnsafeBuffer[3];
    private final Position hwmPosition;
    private final List<ReadablePosition> subscriberPositions;
    private final LossDetector lossDetector;
    private final AtomicCounter heartbeatsReceived;
    private final AtomicCounter statusMessagesSent;
    private final AtomicCounter nakMessagesSent;
    private final AtomicCounter flowControlUnderRuns;
    private final AtomicCounter flowControlOverRuns;
    private boolean reachedEndOfLife = false;

    public PublicationImage(long correlationId, long imageLivenessTimeoutNs, ReceiveChannelEndpoint channelEndpoint, InetSocketAddress controlAddress, int sessionId, int streamId, int initialTermId, int activeTermId, int initialTermOffset, int initialWindowLength, RawLog rawLog, FeedbackDelayGenerator lossFeedbackDelayGenerator, List<ReadablePosition> subscriberPositions, Position hwmPosition, NanoClock clock, SystemCounters systemCounters, InetSocketAddress sourceAddress) {
        this.correlationId = correlationId;
        this.imageLivenessTimeoutNs = imageLivenessTimeoutNs;
        this.channelEndpoint = channelEndpoint;
        this.controlAddress = controlAddress;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.rawLog = rawLog;
        this.subscriberPositions = subscriberPositions;
        this.hwmPosition = hwmPosition;
        this.sourceAddress = sourceAddress;
        this.initialTermId = initialTermId;
        this.heartbeatsReceived = systemCounters.get(SystemCounterDescriptor.HEARTBEATS_RECEIVED);
        this.statusMessagesSent = systemCounters.get(SystemCounterDescriptor.STATUS_MESSAGES_SENT);
        this.nakMessagesSent = systemCounters.get(SystemCounterDescriptor.NAK_MESSAGES_SENT);
        this.flowControlUnderRuns = systemCounters.get(SystemCounterDescriptor.FLOW_CONTROL_UNDER_RUNS);
        this.flowControlOverRuns = systemCounters.get(SystemCounterDescriptor.FLOW_CONTROL_OVER_RUNS);
        long time = clock.nanoTime();
        this.clock = clock;
        this.timeOfLastStatusChange = time;
        this.lastPacketTimestamp = time;
        for (int i = 0; i < 3; ++i) {
            this.termBuffers[i] = rawLog.partitions()[i].termBuffer();
        }
        this.lossDetector = new LossDetector(lossFeedbackDelayGenerator, this);
        int termLength = rawLog.termLength();
        this.currentWindowLength = Math.min(termLength, initialWindowLength);
        this.currentGain = this.currentWindowLength / 4;
        this.termLengthMask = termLength - 1;
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        long initialPosition = LogBufferDescriptor.computePosition((int)activeTermId, (int)initialTermOffset, (int)this.positionBitsToShift, (int)initialTermId);
        this.newStatusMessagePosition = this.lastStatusMessagePosition = initialPosition - (long)(this.currentGain + 1);
        this.rebuildPosition = initialPosition;
        hwmPosition.setOrdered(initialPosition);
    }

    public void close() {
        this.rawLog.close();
        this.hwmPosition.close();
        this.subscriberPositions.forEach(ReadablePosition::close);
    }

    public long correlationId() {
        return this.correlationId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public String channelUriString() {
        return this.channelEndpoint.originalUriString();
    }

    InetSocketAddress sourceAddress() {
        return this.sourceAddress;
    }

    ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    void removeFromDispatcher() {
        this.channelEndpoint.removePublicationImage(this);
    }

    public boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        return this.streamId == streamId && this.channelEndpoint == channelEndpoint;
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    public Status status() {
        return this.status;
    }

    public void status(Status status) {
        this.timeOfLastStatusChange = this.clock.nanoTime();
        this.status = status;
    }

    void ifActiveGoInactive() {
        if (Status.ACTIVE == this.status) {
            this.status(Status.INACTIVE);
        }
    }

    @Override
    public void onLossDetected(int termId, int termOffset, int length) {
        long changeNumber;
        this.beginLossChange = changeNumber = this.beginLossChange + 1L;
        this.lossTermId = termId;
        this.lossTermOffset = termOffset;
        this.lossLength = length;
        this.endLossChange = changeNumber;
    }

    int trackRebuild(long now) {
        long newRebuildPosition;
        long minSubscriberPosition = Long.MAX_VALUE;
        long maxSubscriberPosition = Long.MIN_VALUE;
        List<ReadablePosition> subscriberPositions = this.subscriberPositions;
        int size = subscriberPositions.size();
        for (int i = 0; i < size; ++i) {
            long position = subscriberPositions.get(i).getVolatile();
            minSubscriberPosition = Math.min(minSubscriberPosition, position);
            maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
        }
        long oldRebuildPosition = this.rebuildPosition;
        long rebuildPosition = Math.max(oldRebuildPosition, maxSubscriberPosition);
        int positionBitsToShift = this.positionBitsToShift;
        int index = LogBufferDescriptor.indexByPosition((long)rebuildPosition, (int)positionBitsToShift);
        int workCount = this.lossDetector.scan(this.termBuffers[index], rebuildPosition, this.hwmPosition.getVolatile(), now, this.termLengthMask, positionBitsToShift, this.initialTermId);
        int rebuildTermOffset = (int)rebuildPosition & this.termLengthMask;
        this.rebuildPosition = newRebuildPosition = rebuildPosition - (long)rebuildTermOffset + (long)this.lossDetector.rebuildOffset();
        int newTermCount = (int)(newRebuildPosition >>> positionBitsToShift);
        int oldTermCount = (int)(oldRebuildPosition >>> positionBitsToShift);
        if (newTermCount > oldTermCount) {
            int oldTermCountIndex = LogBufferDescriptor.indexByTermCount((int)oldTermCount);
            UnsafeBuffer termBuffer = this.termBuffers[LogBufferDescriptor.previousPartitionIndex((int)oldTermCountIndex)];
            termBuffer.setMemory(0, termBuffer.capacity(), (byte)0);
        }
        if (minSubscriberPosition > this.newStatusMessagePosition + (long)this.currentGain) {
            this.newStatusMessagePosition = minSubscriberPosition;
        }
        return workCount;
    }

    int insertPacket(int termId, int termOffset, UnsafeBuffer buffer, int length) {
        int bytesReceived = length;
        int positionBitsToShift = this.positionBitsToShift;
        long packetPosition = LogBufferDescriptor.computePosition((int)termId, (int)termOffset, (int)positionBitsToShift, (int)this.initialTermId);
        long proposedPosition = packetPosition + (long)length;
        long windowPosition = this.lastStatusMessagePosition;
        if (this.isHeartbeat(buffer, length)) {
            this.hwmCandidate(packetPosition);
            this.heartbeatsReceived.orderedIncrement();
        } else if (this.isFlowControlUnderRun(windowPosition, packetPosition) || this.isFlowControlOverRun(windowPosition, proposedPosition)) {
            bytesReceived = 0;
        } else {
            UnsafeBuffer termBuffer = this.termBuffers[LogBufferDescriptor.indexByPosition((long)packetPosition, (int)positionBitsToShift)];
            TermRebuilder.insert((UnsafeBuffer)termBuffer, (int)termOffset, (UnsafeBuffer)buffer, (int)length);
            this.hwmCandidate(proposedPosition);
        }
        return bytesReceived;
    }

    boolean checkForActivity(long now) {
        boolean activity = true;
        if (now > this.lastPacketTimestamp + this.imageLivenessTimeoutNs) {
            activity = false;
        }
        return activity;
    }

    int sendPendingStatusMessage(long now, long statusMessageTimeout) {
        long statusMessagePosition;
        int workCount = 0;
        if (Status.ACTIVE == this.status && ((statusMessagePosition = this.newStatusMessagePosition) != this.lastStatusMessagePosition || now > this.lastStatusMessageTimestamp + statusMessageTimeout)) {
            int termId = LogBufferDescriptor.computeTermIdFromPosition((long)statusMessagePosition, (int)this.positionBitsToShift, (int)this.initialTermId);
            int termOffset = (int)statusMessagePosition & this.termLengthMask;
            this.channelEndpoint.sendStatusMessage(this.controlAddress, this.sessionId, this.streamId, termId, termOffset, this.currentWindowLength, (short)0);
            this.lastStatusMessageTimestamp = now;
            this.lastStatusMessagePosition = statusMessagePosition;
            this.statusMessagesSent.orderedIncrement();
            workCount = 1;
        }
        return workCount;
    }

    int sendPendingNak() {
        int workCount = 0;
        long changeNumber = this.endLossChange;
        if (changeNumber != this.lastChangeNumber) {
            int termId = this.lossTermId;
            int termOffset = this.lossTermOffset;
            int length = this.lossLength;
            UnsafeAccess.UNSAFE.loadFence();
            if (changeNumber == this.beginLossChange) {
                this.channelEndpoint.sendNakMessage(this.controlAddress, this.sessionId, this.streamId, termId, termOffset, length);
                this.lastChangeNumber = changeNumber;
                this.nakMessagesSent.orderedIncrement();
                workCount = 1;
            }
        }
        return workCount;
    }

    void removeSubscriber(ReadablePosition subscriberPosition) {
        this.subscriberPositions.remove(subscriberPosition);
        subscriberPosition.close();
    }

    void addSubscriber(ReadablePosition subscriberPosition) {
        this.subscriberPositions.add(subscriberPosition);
    }

    int subscriberCount() {
        return this.subscriberPositions.size();
    }

    long rebuildPosition() {
        return this.rebuildPosition;
    }

    @Override
    public void onTimeEvent(long time, DriverConductor conductor) {
        switch (this.status) {
            case INACTIVE: {
                if (!this.isDrained() && time <= this.timeOfLastStatusChange + this.imageLivenessTimeoutNs) break;
                this.status(Status.LINGER);
                conductor.imageTransitionToLinger(this);
                break;
            }
            case LINGER: {
                if (time <= this.timeOfLastStatusChange + this.imageLivenessTimeoutNs) break;
                this.reachedEndOfLife = true;
                conductor.cleanupImage(this);
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
    }

    public long timeOfLastStateChange() {
        return this.timeOfLastStatusChange;
    }

    public void delete() {
        this.close();
    }

    private boolean isDrained() {
        long minSubscriberPosition = Long.MAX_VALUE;
        List<ReadablePosition> subscriberPositions = this.subscriberPositions;
        int size = subscriberPositions.size();
        for (int i = 0; i < size; ++i) {
            minSubscriberPosition = Math.min(minSubscriberPosition, subscriberPositions.get(i).getVolatile());
        }
        return minSubscriberPosition >= this.rebuildPosition;
    }

    private boolean isHeartbeat(UnsafeBuffer buffer, int length) {
        return length == 32 && buffer.getInt(0) == 0;
    }

    private void hwmCandidate(long proposedPosition) {
        this.lastPacketTimestamp = this.clock.nanoTime();
        this.hwmPosition.proposeMaxOrdered(proposedPosition);
    }

    private boolean isFlowControlUnderRun(long windowPosition, long packetPosition) {
        boolean isFlowControlUnderRun;
        boolean bl = isFlowControlUnderRun = packetPosition < windowPosition;
        if (isFlowControlUnderRun) {
            this.flowControlUnderRuns.orderedIncrement();
        }
        return isFlowControlUnderRun;
    }

    private boolean isFlowControlOverRun(long windowPosition, long proposedPosition) {
        boolean isFlowControlOverRun;
        boolean bl = isFlowControlOverRun = proposedPosition > windowPosition + (long)this.currentWindowLength;
        if (isFlowControlOverRun) {
            this.flowControlOverRuns.orderedIncrement();
        }
        return isFlowControlOverRun;
    }

    static enum Status {
        INIT,
        ACTIVE,
        INACTIVE,
        LINGER;

    }
}

