/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.RetransmitSender;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.AtomicCounter;

public class RetransmitHandler {
    private final RetransmitAction[] retransmitActionPool = new RetransmitAction[16];
    private final Long2ObjectHashMap<RetransmitAction> activeRetransmitByPositionMap = new Long2ObjectHashMap();
    private final NanoClock nanoClock;
    private final AtomicCounter invalidPackets;
    private final FeedbackDelayGenerator delayGenerator;
    private final FeedbackDelayGenerator lingerTimeoutGenerator;
    private final int initialTermId;
    private final int capacity;
    private final int positionBitsToShift;

    public RetransmitHandler(NanoClock nanoClock, SystemCounters systemCounters, FeedbackDelayGenerator delayGenerator, FeedbackDelayGenerator lingerTimeoutGenerator, int initialTermId, int capacity) {
        this.nanoClock = nanoClock;
        this.invalidPackets = systemCounters.get(SystemCounterDescriptor.INVALID_PACKETS);
        this.delayGenerator = delayGenerator;
        this.lingerTimeoutGenerator = lingerTimeoutGenerator;
        this.initialTermId = initialTermId;
        this.capacity = capacity;
        this.positionBitsToShift = Integer.numberOfTrailingZeros(capacity);
        for (int i = 0; i < 16; ++i) {
            this.retransmitActionPool[i] = new RetransmitAction();
        }
    }

    public void onNak(int termId, int termOffset, int length, RetransmitSender retransmitSender) {
        if (!this.isInvalid(termOffset)) {
            long position = LogBufferDescriptor.computePosition((int)termId, (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
            if (this.activeRetransmitByPositionMap.size() < 16 && null == this.activeRetransmitByPositionMap.get(position)) {
                RetransmitAction action = this.assignRetransmitAction();
                action.termId = termId;
                action.termOffset = termOffset;
                action.length = Math.min(length, this.capacity - termOffset);
                action.position = position;
                long delay = this.determineRetransmitDelay();
                if (0L == delay) {
                    this.perform(action, retransmitSender);
                    action.linger(this.determineLingerTimeout());
                } else {
                    action.delay(delay);
                }
                this.activeRetransmitByPositionMap.put(position, (Object)action);
            }
        }
    }

    public void onRetransmitReceived(int termId, int termOffset) {
        long position = LogBufferDescriptor.computePosition((int)termId, (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
        RetransmitAction action = (RetransmitAction)this.activeRetransmitByPositionMap.get(position);
        if (null != action && State.DELAYED == action.state) {
            action.cancel();
        }
    }

    public int processTimeouts(long now, RetransmitSender retransmitSender) {
        int result = 0;
        if (this.activeRetransmitByPositionMap.size() > 0) {
            block4: for (RetransmitAction action : this.retransmitActionPool) {
                switch (action.state) {
                    case DELAYED: {
                        if (now <= action.expire) continue block4;
                        action.onDelayTimeout(retransmitSender);
                        ++result;
                        continue block4;
                    }
                    case LINGERING: {
                        if (now <= action.expire) continue block4;
                        action.onLingerTimeout();
                        ++result;
                    }
                }
            }
        }
        return result;
    }

    private boolean isInvalid(int termOffset) {
        boolean isInvalid;
        boolean bl = isInvalid = termOffset >= this.capacity - 32;
        if (isInvalid) {
            this.invalidPackets.orderedIncrement();
        }
        return isInvalid;
    }

    private long determineRetransmitDelay() {
        return this.delayGenerator.generateDelay();
    }

    private long determineLingerTimeout() {
        return this.lingerTimeoutGenerator.generateDelay();
    }

    private void perform(RetransmitAction action, RetransmitSender retransmitSender) {
        retransmitSender.resend(action.termId, action.termOffset, action.length);
    }

    private RetransmitAction assignRetransmitAction() {
        for (RetransmitAction action : this.retransmitActionPool) {
            if (State.INACTIVE != action.state) continue;
            return action;
        }
        throw new IllegalStateException("no more INACTIVE RetransmitActions");
    }

    final class RetransmitAction {
        long expire;
        long position;
        int termId;
        int termOffset;
        int length;
        State state = State.INACTIVE;

        RetransmitAction() {
        }

        public void delay(long delay) {
            this.state = State.DELAYED;
            this.expire = RetransmitHandler.this.nanoClock.nanoTime() + delay;
        }

        public void linger(long timeout) {
            this.state = State.LINGERING;
            this.expire = RetransmitHandler.this.nanoClock.nanoTime() + timeout;
        }

        public void onDelayTimeout(RetransmitSender retransmitSender) {
            RetransmitHandler.this.perform(this, retransmitSender);
            this.linger(RetransmitHandler.this.determineLingerTimeout());
        }

        public void onLingerTimeout() {
            RetransmitHandler.this.activeRetransmitByPositionMap.remove(this.position);
            this.state = State.INACTIVE;
        }

        public void cancel() {
            RetransmitHandler.this.activeRetransmitByPositionMap.remove(this.position);
            this.state = State.INACTIVE;
        }
    }

    private static enum State {
        DELAYED,
        LINGERING,
        INACTIVE;

    }
}

