/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.Configuration;
import io.aeron.driver.DirectPublication;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.util.IdentityHashMap;
import java.util.Map;
import org.agrona.concurrent.status.ReadablePosition;

public class SubscriptionLink
implements DriverManagedResource {
    private final long registrationId;
    private final int streamId;
    private final ReceiveChannelEndpoint channelEndpoint;
    private final AeronClient aeronClient;
    private final Map<PublicationImage, ReadablePosition> positionByImageMap = new IdentityHashMap<PublicationImage, ReadablePosition>();
    private final DirectPublication directPublication;
    private final ReadablePosition directPublicationSubscriberPosition;
    private boolean reachedEndOfLife = false;

    public SubscriptionLink(long registrationId, ReceiveChannelEndpoint channelEndpoint, int streamId, AeronClient aeronClient) {
        this.registrationId = registrationId;
        this.channelEndpoint = channelEndpoint;
        this.streamId = streamId;
        this.aeronClient = aeronClient;
        this.directPublication = null;
        this.directPublicationSubscriberPosition = null;
    }

    public SubscriptionLink(long registrationId, int streamId, DirectPublication directPublication, ReadablePosition subscriberPosition, AeronClient aeronClient) {
        this.registrationId = registrationId;
        this.channelEndpoint = null;
        this.streamId = streamId;
        this.aeronClient = aeronClient;
        this.directPublication = directPublication;
        directPublication.incRef();
        this.directPublicationSubscriberPosition = subscriberPosition;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    public int streamId() {
        return this.streamId;
    }

    public boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        return channelEndpoint == this.channelEndpoint && streamId == this.streamId;
    }

    public void addImage(PublicationImage image, ReadablePosition position) {
        this.positionByImageMap.put(image, position);
    }

    public void removeImage(PublicationImage image) {
        this.positionByImageMap.remove(image);
    }

    public void close() {
        this.positionByImageMap.forEach(PublicationImage::removeSubscriber);
        if (null != this.directPublication) {
            this.directPublication.removeSubscription(this.directPublicationSubscriberPosition);
            this.directPublication.decRef();
        }
    }

    @Override
    public void onTimeEvent(long time, DriverConductor conductor) {
        if (time > this.aeronClient.timeOfLastKeepalive() + Configuration.CLIENT_LIVENESS_TIMEOUT_NS) {
            this.reachedEndOfLife = true;
            conductor.cleanupSubscriptionLink(this);
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
    }

    public long timeOfLastStateChange() {
        return this.aeronClient.timeOfLastKeepalive();
    }

    public void delete() {
        this.close();
    }
}

