/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferPartition;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.stream.Stream;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.DistinctErrorLog;

class MappedRawLog
implements RawLog {
    private static final int ONE_GIG = 0x40000000;
    private static final int PAGE_LENGTH = 4096;
    private final int termLength;
    private final LogBufferPartition[] partitions;
    private final File logFile;
    private final MappedByteBuffer[] mappedBuffers;
    private final UnsafeBuffer logMetaDataBuffer;
    private final DistinctErrorLog errorLog;

    MappedRawLog(File location, boolean useSparseFiles, int termLength, DistinctErrorLog errorLog) {
        this.termLength = termLength;
        this.errorLog = errorLog;
        this.logFile = location;
        this.partitions = new LogBufferPartition[3];
        try (RandomAccessFile raf = new RandomAccessFile(this.logFile, "rw");
             FileChannel logChannel = raf.getChannel();){
            long logLength = LogBufferDescriptor.computeLogLength((int)termLength);
            raf.setLength(logLength);
            if (logLength <= Integer.MAX_VALUE) {
                MappedByteBuffer mappedBuffer = logChannel.map(FileChannel.MapMode.READ_WRITE, 0L, logLength);
                if (!useSparseFiles) {
                    MappedRawLog.allocatePages(mappedBuffer, (int)logLength);
                }
                this.mappedBuffers = new MappedByteBuffer[]{mappedBuffer};
                int metaDataSectionOffset = termLength * 3;
                for (int i = 0; i < 3; ++i) {
                    int metaDataOffset = metaDataSectionOffset + i * LogBufferDescriptor.TERM_META_DATA_LENGTH;
                    this.partitions[i] = new LogBufferPartition(new UnsafeBuffer((ByteBuffer)mappedBuffer, i * termLength, termLength), new UnsafeBuffer((ByteBuffer)mappedBuffer, metaDataOffset, LogBufferDescriptor.TERM_META_DATA_LENGTH));
                }
                this.logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)mappedBuffer, (int)(logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
            } else {
                MappedByteBuffer metaDataMappedBuffer;
                this.mappedBuffers = new MappedByteBuffer[4];
                long metaDataSectionOffset = (long)termLength * 3L;
                int metaDataSectionLength = (int)(logLength - metaDataSectionOffset);
                this.mappedBuffers[this.mappedBuffers.length - 1] = metaDataMappedBuffer = logChannel.map(FileChannel.MapMode.READ_WRITE, metaDataSectionOffset, metaDataSectionLength);
                for (int i = 0; i < 3; ++i) {
                    this.mappedBuffers[i] = logChannel.map(FileChannel.MapMode.READ_WRITE, (long)termLength * (long)i, termLength);
                    if (!useSparseFiles) {
                        MappedRawLog.allocatePages(this.mappedBuffers[i], termLength);
                    }
                    this.partitions[i] = new LogBufferPartition(new UnsafeBuffer((ByteBuffer)this.mappedBuffers[i]), new UnsafeBuffer((ByteBuffer)metaDataMappedBuffer, i * LogBufferDescriptor.TERM_META_DATA_LENGTH, LogBufferDescriptor.TERM_META_DATA_LENGTH));
                }
                this.logMetaDataBuffer = new UnsafeBuffer((ByteBuffer)metaDataMappedBuffer, metaDataSectionLength - LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public int termLength() {
        return this.termLength;
    }

    @Override
    public void close() {
        for (MappedByteBuffer buffer : this.mappedBuffers) {
            IoUtil.unmap((MappedByteBuffer)buffer);
        }
        if (!this.logFile.delete()) {
            this.errorLog.record((Throwable)new IllegalStateException(String.format("could not delete file %s", this.logFile)));
        }
    }

    public Stream<LogBufferPartition> stream() {
        return Stream.of(this.partitions);
    }

    @Override
    public LogBufferPartition[] partitions() {
        return this.partitions;
    }

    @Override
    public UnsafeBuffer logMetaData() {
        return this.logMetaDataBuffer;
    }

    @Override
    public ByteBuffer[] sliceTerms() {
        ByteBuffer[] terms = new ByteBuffer[3];
        if (this.termLength < 0x40000000) {
            MappedByteBuffer buffer = this.mappedBuffers[0];
            for (int i = 0; i < 3; ++i) {
                buffer.limit(this.termLength * i + this.termLength).position(this.termLength * i);
                terms[i] = buffer.slice();
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                terms[i] = this.mappedBuffers[i].duplicate();
            }
        }
        return terms;
    }

    @Override
    public String logFileName() {
        return this.logFile.getAbsolutePath();
    }

    private static void allocatePages(MappedByteBuffer buffer, int length) {
        for (int i = 0; i < length; i += 4096) {
            buffer.put(i, (byte)0);
        }
    }
}

