/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.FileMappingConvention;
import io.aeron.driver.buffer.MappedRawLog;
import io.aeron.driver.buffer.RawLog;
import java.io.File;
import org.agrona.IoUtil;
import org.agrona.concurrent.errors.DistinctErrorLog;

public class RawLogFactory {
    private final DistinctErrorLog errorLog;
    private final int publicationTermBufferLength;
    private final int imagesTermBufferMaxLength;
    private final int ipcPublicationTermBufferLength;
    private final boolean useSparseFiles;
    private final File publicationsDir;
    private final File imagesDir;

    public RawLogFactory(String dataDirectoryName, int publicationTermBufferLength, int imagesTermBufferMaxLength, int ipcPublicationTermBufferLength, boolean useSparseFiles, DistinctErrorLog errorLog) {
        this.errorLog = errorLog;
        this.useSparseFiles = useSparseFiles;
        FileMappingConvention fileMappingConvention = new FileMappingConvention(dataDirectoryName);
        this.publicationsDir = fileMappingConvention.publicationsDir();
        this.imagesDir = fileMappingConvention.imagesDir();
        IoUtil.ensureDirectoryExists((File)this.publicationsDir, (String)"publications");
        IoUtil.ensureDirectoryExists((File)this.imagesDir, (String)"images");
        this.publicationTermBufferLength = publicationTermBufferLength;
        this.imagesTermBufferMaxLength = imagesTermBufferMaxLength;
        this.ipcPublicationTermBufferLength = ipcPublicationTermBufferLength;
    }

    public RawLog newNetworkPublication(String channel, int sessionId, int streamId, long correlationId) {
        return this.newInstance(this.publicationsDir, channel, sessionId, streamId, correlationId, this.publicationTermBufferLength);
    }

    public RawLog newNetworkedImage(String channel, int sessionId, int streamId, long correlationId, int termBufferLength) {
        if (termBufferLength > this.imagesTermBufferMaxLength) {
            throw new IllegalArgumentException("image term buffer larger than max length: " + termBufferLength + " > " + this.imagesTermBufferMaxLength);
        }
        return this.newInstance(this.imagesDir, channel, sessionId, streamId, correlationId, termBufferLength);
    }

    public RawLog newDirectPublication(int sessionId, int streamId, long correlationId) {
        return this.newInstance(this.publicationsDir, "ipc", sessionId, streamId, correlationId, this.ipcPublicationTermBufferLength);
    }

    private RawLog newInstance(File rootDir, String channel, int sessionId, int streamId, long correlationId, int termBufferLength) {
        File location = FileMappingConvention.streamLocation(rootDir, channel, sessionId, streamId, correlationId);
        return new MappedRawLog(location, this.useSparseFiles, termBufferLength, this.errorLog);
    }
}

