/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.DebugChannelEndpointConfiguration;
import io.aeron.driver.ext.LossGenerator;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class DebugSendChannelEndpoint
extends SendChannelEndpoint {
    private final LossGenerator dataLossGenerator;
    private final LossGenerator controlLossGenerator;
    private final UnsafeBuffer dataBuffer = new UnsafeBuffer(ByteBuffer.allocate(0));

    public DebugSendChannelEndpoint(UdpChannel udpChannel, MediaDriver.Context context) {
        this(udpChannel, context, DebugChannelEndpointConfiguration.sendDataLossGeneratorSupplier(), DebugChannelEndpointConfiguration.sendControlLossGeneratorSupplier());
    }

    public DebugSendChannelEndpoint(UdpChannel udpChannel, MediaDriver.Context context, LossGenerator dataLossGenerator, LossGenerator controlLossGenerator) {
        super(udpChannel, context);
        this.dataLossGenerator = dataLossGenerator;
        this.controlLossGenerator = controlLossGenerator;
    }

    @Override
    public int send(ByteBuffer buffer) {
        int result = buffer.remaining();
        this.dataBuffer.wrap(buffer, buffer.position(), buffer.remaining());
        if (!this.dataLossGenerator.shouldDropFrame(this.connectAddress, this.dataBuffer, buffer.remaining())) {
            result = super.send(buffer);
        }
        return result;
    }

    @Override
    protected int dispatch(UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        int result = 0;
        if (!this.controlLossGenerator.shouldDropFrame(srcAddress, buffer, length)) {
            result = super.dispatch(buffer, length, srcAddress);
        }
        return result;
    }
}

