/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;

public class ControlTransportPoller
extends UdpTransportPoller {
    private SendChannelEndpoint[] transports = new SendChannelEndpoint[0];

    @Override
    public int pollTransports() {
        int bytesReceived = 0;
        try {
            if (this.transports.length <= 5) {
                for (SendChannelEndpoint transport : this.transports) {
                    bytesReceived += transport.pollForData();
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                int length = this.selectedKeySet.size();
                for (int i = 0; i < length; ++i) {
                    bytesReceived += ((SendChannelEndpoint)keys[i].attachment()).pollForData();
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerForRead((SendChannelEndpoint)transport);
    }

    public SelectionKey registerForRead(SendChannelEndpoint transport) {
        SelectionKey key = null;
        try {
            this.transports = (SendChannelEndpoint[])ArrayUtil.add((Object[])this.transports, (Object)transport);
            key = transport.receiveDatagramChannel().register(this.selector, 1, transport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.cancelRead((SendChannelEndpoint)transport);
    }

    public void cancelRead(SendChannelEndpoint transport) {
        this.transports = (SendChannelEndpoint[])ArrayUtil.remove((Object[])this.transports, (Object)transport);
    }
}

